/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.regexp;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class RegexpTag
extends TagSupport {
    private Perl5Matcher patternMatcher = new Perl5Matcher();
    private Pattern pattern;
    private String var;
    private String text;
    private String scope;

    protected final String getText() {
        return this.text;
    }

    protected final Pattern getPattern() {
        return this.pattern;
    }

    protected final Perl5Matcher getPatternMatcher() {
        return this.patternMatcher;
    }

    public final void setExpr(String expr) throws MalformedPatternException {
        Perl5Compiler patternCompiler = new Perl5Compiler();
        this.pattern = patternCompiler.compile(expr);
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final void setVar(String var) {
        this.var = var;
    }

    public final void setScope(String scope) {
        this.scope = scope;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        String resultString;
        if (this.getText() == null || this.getText().length() == 0) {
            throw new MissingAttributeException("text must be provided");
        }
        if (this.pattern == null) {
            throw new MissingAttributeException("expr must be provided");
        }
        if (this.var == null || this.var.length() == 0) {
            throw new MissingAttributeException("var must be provided");
        }
        boolean result = this.getResult();
        String string = resultString = result ? "true" : "false";
        if (this.var != null) {
            if (this.scope != null) {
                this.context.setVariable(this.var, this.scope, (Object)resultString);
            } else {
                this.context.setVariable(this.var, (Object)resultString);
            }
        }
    }

    protected abstract boolean getResult();
}

