/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInitializer;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPInitInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JInterceptorStore {
    public static String INTIALIZER_PREFIX;
    private static boolean init;
    private static JServerRequestInterceptor[] sis;
    private static JClientRequestInterceptor[] cis;
    private static JClientRequestInterceptor[] rcis;
    private static UID uid;
    private static byte[] address;
    private static String[] initializers;
    private static JRMPInitInfoImpl jrmpInfo;

    public static JServerRequestInterceptor[] getLocalServerInterceptors() {
        return sis;
    }

    public static JClientRequestInterceptor[] getLocalClientInterceptors() {
        return cis;
    }

    public static String[] getJRMPInitializers() {
        if (!init) {
            ArrayList<String> ins = new ArrayList<String>();
            Properties sys = System.getProperties();
            Enumeration<?> e = System.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String pkey = (String)e.nextElement();
                if (!pkey.startsWith(INTIALIZER_PREFIX)) continue;
                ins.add(pkey.substring(INTIALIZER_PREFIX.length() + 1));
            }
            int sz = ins.size();
            initializers = new String[sz];
            int i = 0;
            while (i < sz) {
                JInterceptorStore.initializers[i] = (String)ins.get(i);
                ++i;
            }
            return initializers;
        }
        return initializers;
    }

    public static synchronized JClientRequestInterceptor[] setRemoteInterceptors(byte[] raddr, UID ruid, String[] ia) {
        if (Arrays.equals(raddr, address) && ruid.equals(uid)) {
            return rcis;
        }
        jrmpInfo.clear();
        int i = 0;
        while (i < ia.length) {
            JInitializer jinit = null;
            try {
                jinit = (JInitializer)Class.forName(ia[i]).newInstance();
                jinit.pre_init(jrmpInfo);
                jinit.post_init(jrmpInfo);
            }
            catch (Exception e) {
                TraceCarol.error("can not load interceptors", e);
            }
            ++i;
        }
        ruid = uid;
        address = raddr;
        rcis = jrmpInfo.getClientRequestInterceptors();
        return rcis;
    }

    static {
        block3: {
            INTIALIZER_PREFIX = "org.objectweb.PortableInterceptor.JRMPInitializerClass";
            init = false;
            sis = null;
            cis = null;
            rcis = null;
            uid = null;
            address = null;
            initializers = null;
            jrmpInfo = new JRMPInitInfoImpl();
            if (init) break block3;
            try {
                JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();
                String[] ins = JInterceptorStore.getJRMPInitializers();
                int i = 0;
                while (i < ins.length) {
                    JInitializer jinit = (JInitializer)Thread.currentThread().getContextClassLoader().loadClass(ins[i]).newInstance();
                    jinit.pre_init(jrmpInfo);
                    jinit.post_init(jrmpInfo);
                    ++i;
                }
                sis = jrmpInfo.getServerRequestInterceptors();
                cis = jrmpInfo.getClientRequestInterceptors();
                rcis = cis;
                uid = JInterceptorHelper.getSpaceID();
                address = JInterceptorHelper.getInetAddress();
            }
            catch (Exception e) {
                TraceCarol.error("JrmpPRODelegate(), No interceptors found", e);
            }
        }
    }
}

