/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.util;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFClassLoader;
import com.ibm.bsf.util.BSFEventProcessor;
import com.ibm.bsf.util.Bean;
import com.ibm.bsf.util.MethodUtils;
import com.ibm.bsf.util.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EngineUtils {
    static BSFClassLoader bsfCL;

    public static Object createBean(String string, Object[] objectArray) throws BSFException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                classArray[n] = objectArray[n] != null ? objectArray[n].getClass() : null;
                ++n;
            }
        }
        try {
            try {
                Bean bean = ReflectionUtils.createBean(null, string, classArray, objectArray);
                return bean.value;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] instanceof Number) {
                            classArray[n] = Byte.TYPE;
                        } else if (objectArray[n] instanceof Boolean) {
                            classArray[n] = Boolean.TYPE;
                        }
                        ++n;
                    }
                    Bean bean = ReflectionUtils.createBean(null, string, classArray, objectArray);
                    return bean.value;
                }
                catch (Exception exception) {
                    throw noSuchMethodException;
                }
            }
        }
        catch (Exception exception) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, exception.getMessage(), exception);
        }
    }

    public static Object callBeanMethod(Object object, String string, Object[] objectArray) throws BSFException {
        boolean bl;
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            bl = false;
            while (bl < objectArray.length) {
                classArray[bl] = objectArray[bl] == null ? null : objectArray[bl].getClass();
                bl += 1;
            }
        }
        bl = false;
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Method method;
            try {
                method = MethodUtils.getMethod(clazz, string, classArray, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    int n = 0;
                    while (n < objectArray.length) {
                        if (objectArray[n] instanceof Number) {
                            classArray[n] = Byte.TYPE;
                            if (objectArray[n] instanceof Float) {
                                classArray[n] = Float.TYPE;
                            } else if (objectArray[n] instanceof Double) {
                                classArray[n] = Double.TYPE;
                            }
                        } else if (objectArray[n] instanceof Boolean) {
                            classArray[n] = Boolean.TYPE;
                        }
                        ++n;
                    }
                    method = MethodUtils.getMethod(clazz, string, classArray, bl);
                }
                catch (Exception exception) {
                    throw noSuchMethodException;
                }
            }
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : null;
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "method invocation failed: " + exception + (throwable == null ? "" : " target exception: " + throwable), throwable);
        }
    }

    public static Class loadClass(BSFManager bSFManager, String string) throws BSFException {
        ClassLoader classLoader = bSFManager.getClassLoader();
        try {
            return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (bsfCL == null) {
                    bsfCL = new BSFClassLoader();
                }
                bsfCL.setTempDir(bSFManager.getTempDir());
                return bsfCL.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "unable to load class '" + string + "':" + classNotFoundException, classNotFoundException);
            }
        }
    }

    public static void addEventListener(Object object, String string, String string2, BSFEngine bSFEngine, BSFManager bSFManager, String string3, int n, int n2, Object object2) throws BSFException {
        BSFEventProcessor bSFEventProcessor = new BSFEventProcessor(bSFEngine, bSFManager, string2, string3, n, n2, object2);
        try {
            ReflectionUtils.addEventListener(object, string, bSFEventProcessor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "ouch while adding event listener: " + exception, exception);
        }
    }

    public static String getTypeSignatureString(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            return "V";
        }
        StringBuffer stringBuffer = new StringBuffer("L");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(";");
        return stringBuffer.toString().replace('.', '/');
    }
}

