/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Change;
import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.SourceControlObject;
import com.perforce.api.User;
import com.perforce.api.Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Counter
extends SourceControlObject {
    private String name = "";
    private int value = -1;
    private static HashDecay counters = null;

    public Counter() {
        this.getCache();
    }

    public Counter(String name) {
        this(null, name);
    }

    public Counter(Env environ, String name) {
        this();
        this.setEnv(environ);
        this.name = name;
    }

    private static HashDecay setCache() {
        if (null == counters) {
            counters = new HashDecay(300000L);
            counters.start();
        }
        return counters;
    }

    public HashDecay getCache() {
        return Counter.setCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void commit() throws CommitException {
        boolean valid = false;
        String[] cmd = new String[]{"p4", "counter", this.name, String.valueOf(this.value)};
        P4Process p = null;
        try {
            String l;
            p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (!l.startsWith("Counter") || !l.endsWith("set.")) continue;
                valid = true;
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            try {
                if (null != p) {
                    p.closeProcess();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new CommitException(ex);
        }
        if (!valid) {
            throw new CommitException("Counter " + this.name + " not set.");
        }
    }

    public void sync() throws PerforceException {
        String[] cmd = new String[]{"p4", "counter", this.name};
        P4Process p = null;
        try {
            p = new P4Process(this.getEnv());
            p.exec(cmd);
            String l = p.readLine();
            this.value = Integer.valueOf(l);
            while (null != (l = p.readLine())) {
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            try {
                if (null != p) {
                    p.closeProcess();
                }
            }
            catch (Exception ign) {
                // empty catch block
            }
            throw new PerforceException(ex.getMessage());
        }
    }

    public static Counter[] getCounters(Env env) throws PerforceException {
        Vector<Counter> v = new Vector<Counter>();
        String[] cmd = new String[]{"p4", "counters"};
        P4Process p = null;
        try {
            String l;
            p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                StringTokenizer st = new StringTokenizer(l);
                String name = st.nextToken();
                if (!st.nextToken().equals("=")) continue;
                int num = Integer.parseInt(st.nextToken());
                Counter cntr = new Counter(env, name);
                cntr.setValue(num);
                v.addElement(cntr);
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            try {
                if (null != p) {
                    p.closeProcess();
                }
            }
            catch (Exception ign) {
                // empty catch block
            }
            throw new PerforceException(ex.getMessage());
        }
        if (0 == v.size()) {
            return null;
        }
        return v.toArray(new Counter[0]);
    }

    public Change[] review() throws PerforceException {
        Vector<Change> v = new Vector<Change>();
        String[] cmd = new String[]{"p4", "review", "-t", this.name};
        P4Process p = null;
        try {
            String l;
            p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                StringTokenizer st;
                if (!l.startsWith("Change") || !(st = new StringTokenizer(l)).nextToken().equals("Change")) continue;
                int num = Integer.parseInt(st.nextToken());
                String uid = st.nextToken();
                String email = st.nextToken("<> \t");
                String name = st.nextToken("<> ()\t");
                try {
                    String t;
                    while (null != (t = st.nextToken("<> ()\t"))) {
                        name = name + " " + t;
                    }
                }
                catch (NoSuchElementException ex) {
                    // empty catch block
                }
                Change chng = new Change(this.getEnv());
                chng.setNumber(num);
                User usr = new User(uid);
                usr.setEnv(this.getEnv());
                usr.setEmail(email);
                usr.setFullName(name);
                chng.setUser(usr);
                v.addElement(chng);
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            try {
                if (null != p) {
                    p.closeProcess();
                }
            }
            catch (Exception ign) {
                // empty catch block
            }
            throw new PerforceException(ex.getMessage());
        }
        if (0 == v.size()) {
            return null;
        }
        return v.toArray(new Change[0]);
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<counter name=\"");
        sb.append(this.name);
        sb.append("\" value=\"");
        sb.append(this.value);
        sb.append("\"/>");
        return sb.toString();
    }

    public static void main(String[] argv) {
        Debug.setDebugLevel(99);
        Properties props = new Properties(System.getProperties());
        try {
            props.load(new BufferedInputStream(new FileInputStream(argv[0])));
            System.setProperties(props);
        }
        catch (Exception e) {
            System.err.println("Unable to load properties.");
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        Env environ = new Env(props);
        System.out.println(environ);
        Counter cnt = new Counter(environ, "testval");
        try {
            int i;
            cnt.setValue(42);
            cnt.commit();
            System.out.println("VAL(1): " + cnt.getValue());
            cnt.setValue(66);
            cnt.commit();
            System.out.println("VAL(2): " + cnt.getValue());
            cnt = new Counter(environ, "testval");
            cnt.sync();
            System.out.println("VAL(3): " + cnt.getValue());
            cnt.setValue(6850);
            cnt.commit();
            System.out.println("VAL(4): " + cnt.getValue());
            Change[] chngs = cnt.review();
            int max = 0;
            for (i = 0; i < chngs.length; ++i) {
                User[] usrs;
                System.out.println("Must review change(1): " + chngs[i].getNumber());
                if (max < chngs[i].getNumber()) {
                    max = chngs[i].getNumber();
                }
                if (null == (usrs = chngs[i].reviews())) continue;
                for (int j = 0; j < usrs.length; ++j) {
                    System.out.println("\t" + usrs[j].getFullName());
                }
            }
            cnt.setValue(max);
            cnt.commit();
            chngs = cnt.review();
            if (null != chngs && chngs.length > 0) {
                for (i = 0; i < chngs.length; ++i) {
                    System.out.println("Must review change(2): " + chngs[i].getNumber());
                    if (max >= chngs[i].getNumber()) continue;
                    max = chngs[i].getNumber();
                }
            }
            Counter[] cntrs = Counter.getCounters(environ);
            for (i = 0; i < cntrs.length; ++i) {
                System.out.println("Counter " + cntrs[i].getName() + ": " + cntrs[i].getValue());
            }
        }
        catch (PerforceException e) {
            System.err.println("Unable to set counter value.");
            e.printStackTrace();
            System.exit(-1);
        }
        System.err.println("Cleaning up.");
        Utils.cleanUp();
    }
}

