/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class UrlRewriterTest
extends TestCase {
    private MockResponse response = new MockResponse();

    public void setUp() {
        Log.setLevel("DEBUG");
        this.response = new MockResponse();
    }

    public void test1() {
        Conf conf = new Conf();
        Rule rule1 = new Rule();
        rule1.setFrom("/aaa");
        rule1.setTo("/bbb");
        conf.addRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/aaa");
        RewrittenUrl rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertTrue((boolean)rewrittenRequest.isForward());
        UrlRewriterTest.assertEquals((String)"/bbb", (String)rewrittenRequest.getTarget());
        request = new MockRequest();
        rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertNull((Object)rewrittenRequest);
        request = new MockRequest("/aaa");
        request.setQueryString("bb=cc");
        rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertEquals((String)"/bbb?bb=cc", (String)rewrittenRequest.getTarget());
    }

    public void testAbsoluteRedir() throws IOException, ServletException {
        Conf conf = new Conf();
        Rule rule1 = new Rule();
        rule1.setFrom("^(.*)$");
        rule1.setToType("permanent-redirect");
        rule1.setTo("http://sss.sss.sss");
        conf.addRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/aaa");
        RewrittenUrl rewrittenRequest = urlRewriter.processRequest(request, this.response);
        rewrittenRequest.doRewrite(request, this.response, null);
        UrlRewriterTest.assertEquals((String)"http://sss.sss.sss", (String)this.response.getHeader("Location"));
    }

    public void testNoRules() {
        Conf conf = new Conf();
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/aaa");
        RewrittenUrl rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertNull((Object)rewrittenRequest);
    }

    public void testSetSimple() {
        Conf conf = new Conf();
        Rule rule1 = new Rule();
        rule1.setFrom("^/aaa([0-9]+)(.*)$");
        SetAttribute setAttribute1 = new SetAttribute();
        setAttribute1.setName("blah");
        setAttribute1.setValue("someval");
        rule1.addSetAttribute(setAttribute1);
        SetAttribute setAttribute2 = new SetAttribute();
        setAttribute2.setType("session");
        setAttribute2.setName("sblah");
        setAttribute2.setValue("$1");
        rule1.addSetAttribute(setAttribute2);
        SetAttribute setAttribute3 = new SetAttribute();
        setAttribute3.setType("response-header");
        setAttribute3.setName("Cache-control");
        setAttribute3.setValue("none");
        rule1.addSetAttribute(setAttribute3);
        SetAttribute setAttribute4 = new SetAttribute();
        setAttribute4.setName("action");
        setAttribute4.setValue("delete");
        rule1.addSetAttribute(setAttribute4);
        conf.addRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/aaa4?asdadasd");
        urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertEquals((Object)"someval", (Object)request.getAttribute("blah"));
        UrlRewriterTest.assertEquals((Object)"$1", (Object)request.getSession().getAttribute("sblah"));
        UrlRewriterTest.assertEquals((Object)"delete", (Object)request.getAttribute("action"));
        UrlRewriterTest.assertEquals((String)"none", (String)this.response.getHeader("Cache-control"));
    }

    public void testSetSimpleWithRule() {
        Conf conf = new Conf();
        Rule rule0 = new Rule();
        rule0.setFrom("/bbb([0-9]+)");
        rule0.setTo("/qqq");
        rule0.setToLast("false");
        Rule rule1 = new Rule();
        rule1.setFrom("^/aaa([0-9]+)$");
        SetAttribute setAttribute1 = new SetAttribute();
        setAttribute1.setType("status");
        setAttribute1.setValue("404");
        rule1.addSetAttribute(setAttribute1);
        conf.addRule(rule0);
        conf.addRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/bbb2?asdadasd");
        RewrittenUrl rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertEquals((String)"/qqq?asdadasd", (String)rewrittenRequest.getTarget());
        UrlRewriterTest.assertEquals((int)200, (int)this.response.getStatus());
    }

    public void testBadConf() {
        Conf conf = new Conf();
        Rule rule1 = new Rule();
        conf.addRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/aaa");
        RewrittenUrl rewrittenRequest = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertNull((Object)rewrittenRequest);
    }

    public void testLoadsOfRules() {
        Log.setLevel("ERROR");
        float testAmount = 10000.0f;
        float timePerRule = 3.0f;
        Conf conf = new Conf();
        for (int i = 0; i < 1000; ++i) {
            Rule rule = new Rule();
            rule.setFrom("^/([a-z]+)/([0-9]+)/" + i + "/$");
            rule.setTo("/blah/a/$2/");
            conf.addRule(rule);
        }
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/dir/999/45/");
        urlRewriter.processRequest(request, this.response);
        long timeStart = System.currentTimeMillis();
        for (float i = 0.0f; i < testAmount; i += 1.0f) {
            urlRewriter.processRequest(request, this.response);
            if (i % 500.0f != 0.0f || !(i > 0.0f)) continue;
            System.out.println("avg so far " + (float)(System.currentTimeMillis() - timeStart) / i + "ms per rule");
        }
        long took = System.currentTimeMillis() - timeStart;
        System.out.println("took " + took + "ms " + (float)took / testAmount + "ms  p er rule");
        UrlRewriterTest.assertTrue(((float)took / testAmount < timePerRule ? 1 : 0) != 0);
    }

    public void testNoToElement() {
        Rule rule1 = new Rule();
        rule1.setFrom(".*");
        Condition condition1 = new Condition();
        condition1.setType("header");
        condition1.setName("accept");
        condition1.setValue(".*image/gif.*");
        SetAttribute setAttribute1 = new SetAttribute();
        setAttribute1.setName("imageType");
        setAttribute1.setValue("gif");
        rule1.addSetAttribute(setAttribute1);
        rule1.addCondition(condition1);
        rule1.initialise(null);
        Rule rule2 = new Rule();
        rule2.setFrom(".*");
        Condition condition2 = new Condition();
        condition2.setType("header");
        condition2.setName("accept");
        condition2.setValue(".*image/jpeg.*");
        SetAttribute setAttribute2 = new SetAttribute();
        setAttribute2.setName("imageType");
        setAttribute2.setValue("jpeg");
        rule2.addSetAttribute(setAttribute2);
        rule2.addCondition(condition2);
        rule2.initialise(null);
        Rule rule3 = new Rule();
        rule3.setFrom(".*");
        Condition condition3 = new Condition();
        condition3.setType("header");
        condition3.setName("accept");
        condition3.setValue(".*image/png.*");
        SetAttribute setAttribute3 = new SetAttribute();
        setAttribute3.setName("imageType");
        setAttribute3.setValue("png");
        rule3.addSetAttribute(setAttribute3);
        rule3.addCondition(condition3);
        rule3.initialise(null);
        Rule rule4 = new Rule();
        rule4.setFrom(".*");
        Condition condition4 = new Condition();
        condition4.setType("header");
        condition4.setName("user-agent");
        condition4.setValue("SonyEricssonT68.*");
        SetAttribute setAttribute4 = new SetAttribute();
        setAttribute4.setName("imageType");
        setAttribute4.setValue("png");
        rule4.addSetAttribute(setAttribute4);
        rule4.addCondition(condition4);
        rule4.initialise(null);
        Conf conf = new Conf();
        conf.addRule(rule1);
        conf.addRule(rule2);
        conf.addRule(rule3);
        conf.addRule(rule4);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/images/my.png");
        request.setHeader("accept", "image/png,*/*;q=0.5");
        RewrittenUrl rewrittenUrl1 = urlRewriter.processRequest(request, this.response);
        UrlRewriterTest.assertEquals((String)"png", (String)((String)request.getAttribute("imageType")));
        UrlRewriterTest.assertEquals(null, (Object)rewrittenUrl1);
    }
}

