/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.OutboundRule;
import org.tuckey.web.filters.urlrewrite.RewrittenOutboundUrl;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class UrlRewriter {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$UrlRewriter == null ? (class$org$tuckey$web$filters$urlrewrite$UrlRewriter = UrlRewriter.class$("org.tuckey.web.filters.urlrewrite.UrlRewriter")) : class$org$tuckey$web$filters$urlrewrite$UrlRewriter);
    private Conf conf;
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$UrlRewriter;

    public UrlRewriter(Conf conf) {
        this.conf = conf;
    }

    public RewrittenUrl processRequest(HttpServletRequest hsRequest, HttpServletResponse hsResponse) {
        String query;
        String originalUrl = StringUtils.trim(hsRequest.getRequestURI());
        if (log.isDebugEnabled()) {
            log.debug("processing request for " + originalUrl);
        }
        if (originalUrl == null) {
            log.debug("unable to fetch request uri from request.  This shouldn't happen, it may indicate that the web application server has a bug or that the request was not pased correctly.");
            return null;
        }
        try {
            originalUrl = URLDecoder.decode(originalUrl, "utf-8");
            if (log.isDebugEnabled()) {
                log.debug("after utf-8 decoding " + originalUrl);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("the jvm doesn't seem to support decoding utf-8, matches may not occur correctly.");
            return null;
        }
        String contextPath = hsRequest.getContextPath();
        if (contextPath != null && originalUrl.startsWith(contextPath)) {
            log.debug("context stripped");
            originalUrl = originalUrl.substring(contextPath.length());
        }
        if (originalUrl.indexOf("?") == -1 && (query = hsRequest.getQueryString()) != null && (query = query.trim()).length() > 0) {
            originalUrl = originalUrl + "?" + query;
        }
        if (log.isDebugEnabled()) {
            log.debug("url " + originalUrl);
        }
        if (!this.conf.isOk()) {
            log.debug("configuration is not ok.  not rewriting request.");
            return null;
        }
        List rules = this.conf.getRules();
        if (rules.size() == 0) {
            log.debug("there are no rules setup.  not rewriting request.");
            return null;
        }
        String finalToUrl = originalUrl;
        RewrittenUrl finalRewrittenRequest = null;
        for (int i = 0; i < rules.size(); ++i) {
            Rule rule = (Rule)rules.get(i);
            RewrittenUrl rewrittenUrl = rule.execute(finalToUrl, hsRequest, hsResponse);
            if (rewrittenUrl == null) continue;
            log.trace("got a rewritten url");
            finalRewrittenRequest = rewrittenUrl;
            finalToUrl = rewrittenUrl.getTarget();
            if (!rule.isLast()) continue;
            log.debug("rule is last");
            break;
        }
        return finalRewrittenRequest;
    }

    public Conf getConf() {
        return this.conf;
    }

    protected RewrittenOutboundUrl processEncodeURL(HttpServletResponse hsResponse, HttpServletRequest hsRequest, boolean encodeUrlHasBeenRun, String outboundUrl) {
        if (log.isDebugEnabled()) {
            log.debug("processing outbound url for " + outboundUrl);
        }
        if (outboundUrl == null) {
            return new RewrittenOutboundUrl(outboundUrl, true);
        }
        boolean finalEncodeOutboundUrl = true;
        String finalToUrl = outboundUrl;
        List outboundRules = this.conf.getOutboundRules();
        for (int i = 0; i < outboundRules.size(); ++i) {
            RewrittenOutboundUrl rewrittenUrl;
            OutboundRule outboundRule = (OutboundRule)outboundRules.get(i);
            if (!encodeUrlHasBeenRun && outboundRule.isEncodeFirst() || encodeUrlHasBeenRun && !outboundRule.isEncodeFirst() || (rewrittenUrl = outboundRule.execute(outboundUrl, hsRequest, hsResponse)) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("\"" + outboundRule.getDisplayName() + "\" matched");
            }
            finalToUrl = rewrittenUrl.getTarget();
            finalEncodeOutboundUrl = rewrittenUrl.isEncode();
            if (!outboundRule.isLast()) continue;
            log.debug("rule is last");
            break;
        }
        return new RewrittenOutboundUrl(finalToUrl, finalEncodeOutboundUrl);
    }

    public void destroy() {
        this.conf.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

