/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.ConditionMatch;
import org.tuckey.web.filters.urlrewrite.RuleExecutionOutput;
import org.tuckey.web.filters.urlrewrite.Run;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.TypeConverter;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class RuleBase {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$RuleBase == null ? (class$org$tuckey$web$filters$urlrewrite$RuleBase = RuleBase.class$("org.tuckey.web.filters.urlrewrite.RuleBase")) : class$org$tuckey$web$filters$urlrewrite$RuleBase);
    protected int id;
    private boolean enabled = true;
    private boolean fromCaseSensitive;
    protected boolean initialised;
    protected boolean valid;
    protected String name;
    private String note;
    protected String from;
    protected String to;
    private boolean toEmpty;
    private boolean last = false;
    protected boolean encodeToUrl;
    private int conditionIdCounter;
    private int runIdCounter;
    private Pattern pattern;
    protected final List errors = new ArrayList(5);
    private final List conditions = new ArrayList(5);
    private final List runs = new ArrayList(2);
    protected final List setAttributes = new ArrayList(2);
    private boolean stopFilterChainOnMatch = false;
    protected static final String STOP_FILTER_CHANGE_MATCH_VALUE = "__STOP_FILTER_CHANGE_MATCH_VALUE__";
    private boolean toContainsBackReference = false;
    private static Pattern backRefPattern = Pattern.compile("(?<!\\\\)%([0-9])");
    private boolean toContainsVariable = false;
    private static Pattern toVariablePattern = Pattern.compile("(?<!\\\\)%\\{(.*?)\\}");
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$RuleBase;

    protected RuleExecutionOutput executeBase(String url, HttpServletRequest hsRequest, HttpServletResponse hsResponse) {
        int runsSize;
        int i;
        if (log.isDebugEnabled()) {
            String displayName = this.getDisplayName();
            log.debug(displayName + " run called with " + url);
        }
        if (!this.initialised) {
            log.debug("not initialised, skipping");
            return null;
        }
        if (!this.valid) {
            log.debug("not valid, skipping");
            return null;
        }
        if (!this.enabled) {
            log.debug("not enabled, skipping");
            return null;
        }
        Matcher matcher = this.pattern.matcher(url);
        boolean performToReplacement = false;
        String replacedTo = null;
        if (this.toEmpty || this.stopFilterChainOnMatch) {
            if (!matcher.find()) {
                if (log.isTraceEnabled()) {
                    log.trace("no match on \"from\" (to is empty)");
                }
                return null;
            }
        } else {
            if (!matcher.find()) {
                if (log.isTraceEnabled()) {
                    log.trace("no match on \"from\" for " + this.from + " and " + url);
                }
                return null;
            }
            if (!this.toEmpty) {
                performToReplacement = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("matched \"from\"");
        }
        int conditionsSize = this.conditions.size();
        ConditionMatch lastConditionMatch = null;
        if (conditionsSize > 0) {
            boolean processNextOr = false;
            boolean currentResult = true;
            for (i = 0; i < conditionsSize; ++i) {
                boolean conditionMatches;
                Condition condition = (Condition)this.conditions.get(i);
                ConditionMatch conditionMatch = condition.getConditionMatch(hsRequest);
                if (conditionMatch != null) {
                    lastConditionMatch = conditionMatch;
                }
                boolean bl = conditionMatches = conditionMatch != null;
                currentResult = processNextOr ? (currentResult |= conditionMatches) : (currentResult &= conditionMatches);
                processNextOr = condition.isProcessNextOr();
            }
            if (!currentResult) {
                log.debug("conditions do not match");
                return null;
            }
            log.debug("conditions match");
        }
        if (performToReplacement) {
            replacedTo = this.performBackReferenceReplacement(lastConditionMatch, this.to, hsRequest);
            replacedTo = matcher.replaceAll(replacedTo);
        }
        RuleExecutionOutput ruleExecutionOutput = new RuleExecutionOutput(replacedTo, true);
        int setAttributesSize = this.setAttributes.size();
        if (setAttributesSize > 0) {
            log.trace("setting sttributes");
            for (i = 0; i < setAttributesSize; ++i) {
                SetAttribute setAttribute = (SetAttribute)this.setAttributes.get(i);
                setAttribute.execute(hsRequest, hsResponse);
            }
        }
        if ((runsSize = this.runs.size()) > 0) {
            log.trace("performing runs");
            for (int i2 = 0; i2 < runsSize; ++i2) {
                Run run = (Run)this.runs.get(i2);
                run.execute(hsRequest, hsResponse);
            }
        }
        if (this.toEmpty) {
            log.debug("'to' is empty, no rewrite, only 'set' and or 'run'");
            return null;
        }
        if (this.stopFilterChainOnMatch) {
            ruleExecutionOutput.setStopFilterMatch(true);
            ruleExecutionOutput.setReplacedUrl(null);
        }
        return ruleExecutionOutput;
    }

    private String performBackReferenceReplacement(ConditionMatch lastConditionMatch, String replacedTo, HttpServletRequest hsRequest) {
        int lastCondMatcherGroupCount;
        Matcher lastConditionMatchMatcher;
        if (replacedTo == null) {
            return null;
        }
        if (this.toContainsVariable) {
            Matcher varMatcher = toVariablePattern.matcher(replacedTo);
            StringBuffer sb = new StringBuffer();
            boolean anyMatches = false;
            while (varMatcher.find()) {
                anyMatches = true;
                int groupCount = varMatcher.groupCount();
                if (groupCount < 1) {
                    log.error("group count on backref finder regexp is not as expected");
                    if (!log.isDebugEnabled()) continue;
                    log.error("varMatcher: " + ((Object)varMatcher).toString());
                    continue;
                }
                String varStr = varMatcher.group(1);
                String varValue = "";
                if (varStr != null) {
                    varValue = this.varReplace(varStr, hsRequest);
                    if (log.isDebugEnabled()) {
                        log.debug("resolved to: " + varValue);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("variable reference is null " + varMatcher);
                }
                varMatcher.appendReplacement(sb, varValue);
            }
            if (anyMatches) {
                varMatcher.appendTail(sb);
                log.debug("replaced sb is " + sb);
                replacedTo = sb.toString();
            }
        }
        if (lastConditionMatch != null && this.toContainsBackReference && (lastConditionMatchMatcher = lastConditionMatch.getMatcher()) != null && (lastCondMatcherGroupCount = lastConditionMatchMatcher.groupCount()) > 0) {
            Matcher backRefMatcher = backRefPattern.matcher(replacedTo);
            StringBuffer sb = new StringBuffer();
            boolean anyMatches = false;
            while (backRefMatcher.find()) {
                anyMatches = true;
                int groupCount = backRefMatcher.groupCount();
                if (groupCount < 1) {
                    log.error("group count on backref finder regexp is not as expected");
                    if (!log.isDebugEnabled()) continue;
                    log.error("backRefMatcher: " + ((Object)backRefMatcher).toString());
                    continue;
                }
                String varStr = backRefMatcher.group(1);
                boolean validBackref = false;
                int varInt = 0;
                log.debug("found " + varStr);
                try {
                    varInt = Integer.parseInt(varStr);
                    if (varInt > lastCondMatcherGroupCount) {
                        log.error("backref %" + varInt + " not found in conditon ");
                        if (log.isDebugEnabled()) {
                            log.debug("condition matcher: " + ((Object)lastConditionMatchMatcher).toString());
                        }
                    } else {
                        validBackref = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    log.error("could not parse backref " + varStr + " to number");
                }
                String conditionMatch = "";
                if (validBackref) {
                    conditionMatch = lastConditionMatchMatcher.group(varInt);
                }
                backRefMatcher.appendReplacement(sb, conditionMatch);
            }
            if (anyMatches) {
                backRefMatcher.appendTail(sb);
                if (log.isDebugEnabled()) {
                    log.debug("replaced sb is " + sb);
                }
                replacedTo = sb.toString();
            }
        }
        return replacedTo;
    }

    private String varReplace(String originalVarStr, HttpServletRequest hsRequest) {
        String varType;
        String varSubName = null;
        int colonIdx = originalVarStr.indexOf(":");
        if (colonIdx != -1 && colonIdx + 1 < originalVarStr.length()) {
            varSubName = originalVarStr.substring(colonIdx + 1);
            varType = originalVarStr.substring(0, colonIdx);
            if (log.isDebugEnabled()) {
                log.debug("variable %{" + originalVarStr + "} type: " + varType + ", name: '" + varSubName + "'");
            }
        } else {
            varType = originalVarStr;
            if (log.isDebugEnabled()) {
                log.debug("variable %{" + originalVarStr + "} type: " + varType);
            }
        }
        TypeConverter type = new TypeConverter();
        type.setType(varType);
        switch (type.getTypeShort()) {
            case 4: {
                return String.valueOf(System.currentTimeMillis());
            }
            case 5: {
                return this.calendarVariable(1);
            }
            case 6: {
                return this.calendarVariable(2);
            }
            case 7: {
                return this.calendarVariable(5);
            }
            case 8: {
                return this.calendarVariable(7);
            }
            case 9: {
                return this.calendarVariable(9);
            }
            case 10: {
                return this.calendarVariable(11);
            }
            case 11: {
                return this.calendarVariable(12);
            }
            case 12: {
                return this.calendarVariable(13);
            }
            case 13: {
                return this.calendarVariable(14);
            }
            case 14: {
                return this.attributeVariable(varSubName == null ? null : hsRequest.getAttribute(varSubName), varSubName);
            }
            case 15: {
                return StringUtils.notNull(hsRequest.getAuthType());
            }
            case 16: {
                return StringUtils.notNull(hsRequest.getCharacterEncoding());
            }
            case 17: {
                return String.valueOf(hsRequest.getContentLength());
            }
            case 18: {
                return StringUtils.notNull(hsRequest.getContentType());
            }
            case 19: {
                return StringUtils.notNull(hsRequest.getContextPath());
            }
            case 20: {
                return this.cookieVariable(hsRequest.getCookies(), varSubName);
            }
            case 39: {
                return String.valueOf(hsRequest.getLocalPort());
            }
            case 21: {
                return StringUtils.notNull(hsRequest.getMethod());
            }
            case 22: {
                return StringUtils.notNull(varSubName == null ? null : hsRequest.getParameter(varSubName));
            }
            case 23: {
                return StringUtils.notNull(hsRequest.getPathInfo());
            }
            case 24: {
                return StringUtils.notNull(hsRequest.getPathTranslated());
            }
            case 25: {
                return StringUtils.notNull(hsRequest.getProtocol());
            }
            case 26: {
                return StringUtils.notNull(hsRequest.getQueryString());
            }
            case 27: {
                return StringUtils.notNull(hsRequest.getRemoteAddr());
            }
            case 28: {
                return StringUtils.notNull(hsRequest.getRemoteHost());
            }
            case 29: {
                return StringUtils.notNull(hsRequest.getRemoteUser());
            }
            case 30: {
                return StringUtils.notNull(hsRequest.getRequestedSessionId());
            }
            case 31: {
                return StringUtils.notNull(hsRequest.getRequestURI());
            }
            case 32: {
                StringBuffer requestUrlBuff = hsRequest.getRequestURL();
                String requestUrlStr = null;
                if (requestUrlBuff != null) {
                    requestUrlStr = requestUrlBuff.toString();
                }
                return StringUtils.notNull(requestUrlStr);
            }
            case 33: {
                Object sessionAttributeValue = null;
                if (hsRequest.getSession() != null && varSubName != null) {
                    sessionAttributeValue = hsRequest.getSession().getAttribute(varSubName);
                }
                return this.attributeVariable(sessionAttributeValue, varSubName);
            }
            case 34: {
                boolean sessionNew = false;
                HttpSession session = hsRequest.getSession();
                if (session != null) {
                    sessionNew = session.isNew();
                }
                return String.valueOf(sessionNew);
            }
            case 35: {
                return String.valueOf(hsRequest.getServerPort());
            }
            case 36: {
                return StringUtils.notNull(hsRequest.getServerName());
            }
            case 37: {
                return StringUtils.notNull(hsRequest.getScheme());
            }
            case 38: {
                return String.valueOf(hsRequest.isUserInRole(varSubName));
            }
            case 1: {
                return StringUtils.notNull(hsRequest.getHeader(varSubName));
            }
        }
        log.error("variable %{" + originalVarStr + "} type '" + varType + "' not a valid type");
        return "";
    }

    public String getDisplayName() {
        return null;
    }

    public boolean initialise(ServletContext context) {
        int i;
        this.initialised = true;
        boolean ok = true;
        for (i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (condition.initialise()) continue;
            ok = false;
        }
        for (i = 0; i < this.runs.size(); ++i) {
            Run run = (Run)this.runs.get(i);
            if (run.initialise(context)) continue;
            ok = false;
        }
        for (i = 0; i < this.setAttributes.size(); ++i) {
            SetAttribute setAttribute = (SetAttribute)this.setAttributes.get(i);
            if (setAttribute.initialise()) continue;
            ok = false;
        }
        if (StringUtils.isBlank(this.from)) {
            this.addError("from is not valid because it is blank");
        } else {
            try {
                this.pattern = this.fromCaseSensitive ? Pattern.compile(this.from) : Pattern.compile(this.from, 2);
            }
            catch (PatternSyntaxException e) {
                this.addError("from (" + this.from + ") is an invalid regular expression - " + e.getMessage());
            }
        }
        if (StringUtils.isBlank(this.to) && this.setAttributes.size() == 0 && this.runs.size() == 0) {
            this.addError("to is not valid because it is blank");
        } else if ("null".equalsIgnoreCase(this.to)) {
            this.stopFilterChainOnMatch = true;
        } else if (StringUtils.isBlank(this.to)) {
            this.toEmpty = true;
        } else if (!StringUtils.isBlank(this.to)) {
            Matcher backRefMatcher = backRefPattern.matcher(this.to);
            this.toContainsBackReference = backRefMatcher.find();
            Matcher variableMatcher = toVariablePattern.matcher(this.to);
            this.toContainsVariable = variableMatcher.find();
        }
        if (ok) {
            log.debug("loaded rule " + this.getFullDisplayName());
        } else {
            log.debug("failed to load rule");
        }
        if (this.errors.size() > 0) {
            ok = false;
        }
        this.valid = ok;
        return ok;
    }

    public boolean isToContainsBackReference() {
        return this.toContainsBackReference;
    }

    public boolean isToContainsVariable() {
        return this.toContainsVariable;
    }

    public String getFullDisplayName() {
        return null;
    }

    protected void addError(String s) {
        this.errors.add(s);
        log.error(s);
    }

    public void destroy() {
        for (int i = 0; i < this.runs.size(); ++i) {
            Run run = (Run)this.runs.get(i);
            run.destroy();
        }
    }

    public String getFrom() {
        return this.from;
    }

    protected boolean isReadyToProcess() {
        if (!this.valid) {
            log.debug("not valid, skipping");
            return false;
        }
        if (!this.initialised) {
            log.debug("not initialised, skipping");
            return false;
        }
        if (!this.enabled) {
            log.debug("not enabled, skipping");
            return false;
        }
        return true;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        if (!StringUtils.isBlank(to)) {
            this.to = to;
        }
    }

    public void setToLast(String lastStr) {
        this.last = "true".equalsIgnoreCase(lastStr);
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isStopFilterChainOnMatch() {
        return this.stopFilterChainOnMatch;
    }

    public String getTo() {
        return this.to;
    }

    public int getId() {
        return this.id;
    }

    public List getErrors() {
        return this.errors;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        condition.setId(this.conditionIdCounter++);
    }

    public void addRun(Run run) {
        this.runs.add(run);
        run.setId(this.runIdCounter++);
    }

    public void addSetAttribute(SetAttribute setAttribute) {
        this.setAttributes.add(setAttribute);
    }

    public List getSetAttributes() {
        return this.setAttributes;
    }

    public List getConditions() {
        return this.conditions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isFromCaseSensitive() {
        return this.fromCaseSensitive;
    }

    public void setFromCaseSensitive(boolean fromCaseSensitive) {
        this.fromCaseSensitive = fromCaseSensitive;
    }

    public List getRuns() {
        return this.runs;
    }

    public boolean isValid() {
        return this.valid;
    }

    private String attributeVariable(Object attribObject, String name) {
        String attribValue = null;
        if (attribObject == null) {
            if (log.isDebugEnabled()) {
                log.debug(name + " doesn't exist");
            }
        } else {
            attribValue = attribObject.toString();
        }
        return StringUtils.notNull(attribValue);
    }

    private String cookieVariable(Cookie[] cookies, String name) {
        if (cookies == null) {
            return "";
        }
        if (name == null) {
            return "";
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (cookie == null || !name.equals(cookie.getName())) continue;
            return StringUtils.notNull(cookie.getValue());
        }
        return null;
    }

    private String calendarVariable(int calField) {
        return String.valueOf(Calendar.getInstance().get(calField));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

