/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.Run;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class ConfTest
extends TestCase {
    public static final String BASE_XML_PATH = "/org/tuckey/web/filters/urlrewrite/";
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$ConfTest;

    public void setUp() {
        Log.setLevel("DEBUG");
    }

    public void testGoodNormalConf() throws FileNotFoundException {
        InputStream is = (class$org$tuckey$web$filters$urlrewrite$ConfTest == null ? (class$org$tuckey$web$filters$urlrewrite$ConfTest = ConfTest.class$("org.tuckey.web.filters.urlrewrite.ConfTest")) : class$org$tuckey$web$filters$urlrewrite$ConfTest).getResourceAsStream("/org/tuckey/web/filters/urlrewrite/conf-test1.xml");
        Conf conf = new Conf(is, "conf-test1.xml");
        ConfTest.assertTrue((boolean)conf.isOk());
        List rules = conf.getRules();
        Rule rule = (Rule)rules.get(0);
        ConfTest.assertEquals((String)"basicfrom1", (String)rule.getFrom());
        ConfTest.assertEquals((String)"basicto1", (String)rule.getTo());
        ConfTest.assertFalse((String)"rule 1 last not loading correctly", (boolean)rule.isLast());
        ConfTest.assertEquals((String)"forward", (String)rule.getToType());
        SetAttribute set = (SetAttribute)rule.getSetAttributes().get(0);
        ConfTest.assertEquals((String)("name of set, it's " + set.getName()), (String)"valuenull", (String)set.getName());
        ConfTest.assertNull((String)("value of set should be null, it's " + set.getValue()), (Object)set.getValue());
        Rule rule1 = (Rule)rules.get(1);
        ConfTest.assertEquals((String)"basicfrom2", (String)rule1.getFrom());
        ConfTest.assertEquals((String)"basicto2", (String)rule1.getTo());
        ConfTest.assertTrue((String)"rule 2 last not loading correctly", (boolean)rule1.isLast());
        ConfTest.assertEquals((String)"redirect", (String)rule1.getToType());
        ConfTest.assertEquals((String)"true", (String)("" + rule1.isFromCaseSensitive()));
        Condition cond = (Condition)rule1.getConditions().get(0);
        ConfTest.assertEquals((String)"true", (String)("" + cond.isCaseSensitive()));
        ConfTest.assertEquals((String)"greater", (String)cond.getOperator());
        Rule rule2 = (Rule)rules.get(2);
        SetAttribute set2 = (SetAttribute)rule2.getSetAttributes().get(0);
        ConfTest.assertEquals((String)"blah", (String)set2.getName());
        ConfTest.assertEquals((String)"$1", (String)set2.getValue());
        Rule rule4 = (Rule)rules.get(4);
        Run run = (Run)rule4.getRuns().get(0);
        ConfTest.assertEquals((String)"testValue", (String)run.getInitParam("testName"));
    }

    public void testNoDtdConf() throws FileNotFoundException {
        InputStream is = (class$org$tuckey$web$filters$urlrewrite$ConfTest == null ? (class$org$tuckey$web$filters$urlrewrite$ConfTest = ConfTest.class$("org.tuckey.web.filters.urlrewrite.ConfTest")) : class$org$tuckey$web$filters$urlrewrite$ConfTest).getResourceAsStream("/org/tuckey/web/filters/urlrewrite/conf-test-no-dtd.xml");
        Conf conf = new Conf(is, "conf-test-no-dtd.xml");
        ConfTest.assertTrue((boolean)conf.isOk());
    }

    public void testConfBadParse() throws FileNotFoundException {
        InputStream is = (class$org$tuckey$web$filters$urlrewrite$ConfTest == null ? (class$org$tuckey$web$filters$urlrewrite$ConfTest = ConfTest.class$("org.tuckey.web.filters.urlrewrite.ConfTest")) : class$org$tuckey$web$filters$urlrewrite$ConfTest).getResourceAsStream("/org/tuckey/web/filters/urlrewrite/conf-test-bad-parse.xml");
        Conf conf = new Conf(is, "conf-test-bad-parse.xml");
        ConfTest.assertTrue((boolean)conf.isOk());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

