/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.zip;

import com.atlassian.plugin.util.zip.AbstractUnzipper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class StreamUnzipper
extends AbstractUnzipper {
    private ZipInputStream zis;

    public StreamUnzipper(InputStream zipStream, File destDir) {
        if (zipStream == null) {
            throw new IllegalArgumentException("zip stream cannot be null");
        }
        this.zis = new ZipInputStream(zipStream);
        this.destDir = destDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip() throws IOException {
        ZipEntry zipEntry = this.zis.getNextEntry();
        try {
            while (zipEntry != null) {
                this.saveEntry(this.zis, zipEntry);
                this.zis.closeEntry();
                zipEntry = this.zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File unzipFileInArchive(String fileName) throws IOException {
        File result = null;
        try {
            ZipEntry zipEntry = this.zis.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                if (StringUtils.isNotEmpty((String)entryName) && entryName.startsWith("/")) {
                    entryName = entryName.substring(1);
                }
                if (fileName.equals(entryName)) {
                    result = this.saveEntry(this.zis, zipEntry);
                    break;
                }
                this.zis.closeEntry();
                zipEntry = this.zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.zis);
        }
        return result;
    }

    public ZipEntry[] entries() throws IOException {
        return this.entries(this.zis);
    }
}

