/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import com.atlassian.plugin.util.Timeout;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitUntil {
    private static final Log log = LogFactory.getLog(WaitUntil.class);
    private static final int DEFAULT_STARTUP_WAIT = 60;
    private static final int STARTUP_WAIT = Integer.getInteger("com.atlassian.plugin.startup.wait", 60);

    private WaitUntil() {
    }

    public static boolean invoke(WaitCondition waitCondition) {
        return WaitUntil.invoke(waitCondition, STARTUP_WAIT);
    }

    public static boolean invoke(WaitCondition waitCondition, int tries) {
        int secondMillis = 1000;
        return WaitUntil.invoke(waitCondition, tries * 1000, TimeUnit.MILLISECONDS, 1000);
    }

    public static boolean invoke(WaitCondition waitCondition, int time, TimeUnit unit, int retryInterval) {
        Timeout timeout = Timeout.getMillisTimeout(time, unit);
        boolean successful = false;
        while (!timeout.isExpired()) {
            if (waitCondition.isFinished()) {
                successful = true;
                break;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(waitCondition.getWaitMessage() + ", " + timeout.getRemaining()));
            }
            try {
                Thread.sleep(unit.toMillis(retryInterval));
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return successful;
    }

    public static interface WaitCondition {
        public boolean isFinished();

        public String getWaitMessage();
    }
}

