/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.repositories;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class FilePluginInstaller
implements PluginInstaller {
    private File directory;

    public FilePluginInstaller(File directory) {
        Validate.isTrue((directory != null && directory.exists() ? 1 : 0) != 0, (String)"The plugin installation directory must exist");
        this.directory = directory;
    }

    public void installPlugin(String key, PluginArtifact pluginArtifact) {
        Validate.notNull((Object)key, (String)"The plugin key must be specified");
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must not be null");
        File newPluginFile = new File(this.directory, pluginArtifact.getName());
        if (newPluginFile.exists()) {
            newPluginFile.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(newPluginFile);
            IOUtils.copy((InputStream)pluginArtifact.getInputStream(), (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not install plugin: " + pluginArtifact, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

