/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter;

import com.atlassian.gzipfilter.AbstractFilter;
import com.atlassian.gzipfilter.SelectingResponseWrapper;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import com.atlassian.gzipfilter.selector.DefaultGzipCompatibilitySelectorFactory;
import com.atlassian.gzipfilter.selector.GzipCompatibilitySelector;
import com.atlassian.gzipfilter.selector.GzipCompatibilitySelectorFactory;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GzipFilter
extends AbstractFilter {
    private static final Logger log = Logger.getLogger((Class)GzipFilter.class);
    private static final String ALREADY_FILTERED = GzipFilter.class.getName() + "_already_filtered";
    private static final GzipCompatibilitySelector NO_GZIP_SELECTOR = new NoGzipCompatibilitySelector();
    private final DefaultGzipCompatibilitySelectorFactory factory = new DefaultGzipCompatibilitySelectorFactory();
    private final GzipFilterIntegration integration;
    private FilterConfig filterConfig;

    public GzipFilter(GzipFilterIntegration integration) {
        this.integration = integration;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) == null) {
            this.doFilterInternal(req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    private void doFilterInternal(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        if (req instanceof HttpServletRequest && this.integration.useGzip() && this.isTopLevelRequest(req)) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            GzipCompatibilitySelector selector = this.getCompatibilitySelector(request);
            if (selector.shouldGzip()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"GZIP supported, compressing.");
                }
                SelectingResponseWrapper wrappedResponse = new SelectingResponseWrapper(response, selector, this.integration.getResponseEncoding(request));
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                return;
            }
        }
        chain.doFilter(req, res);
    }

    private GzipCompatibilitySelector getCompatibilitySelector(HttpServletRequest request) {
        String acceptEncodingHeader = request.getHeader("accept-encoding");
        if (acceptEncodingHeader == null || acceptEncodingHeader.indexOf("gzip") == -1) {
            return NO_GZIP_SELECTOR;
        }
        return this.getFactory().getSelector(this.filterConfig, request);
    }

    protected GzipCompatibilitySelectorFactory getFactory() {
        return this.factory;
    }

    private boolean isTopLevelRequest(ServletRequest request) {
        return request.getAttribute("javax.servlet.include.servlet_path") == null;
    }

    private static final class NoGzipCompatibilitySelector
    implements GzipCompatibilitySelector {
        private NoGzipCompatibilitySelector() {
        }

        public boolean shouldGzip(String contentType) {
            return false;
        }

        public boolean shouldGzip() {
            return false;
        }
    }
}

