/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Check {
    public static <T> T notNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T notNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> Iterable<T> contentsNotNull(Iterable<T> iterable, Object errorMessage) {
        Check.notNull(iterable, errorMessage);
        for (T element : iterable) {
            Check.notNull(element, errorMessage);
        }
        return iterable;
    }

    public static String notBlank(String str, Object errorMessage) {
        Check.notNull(str, errorMessage);
        if (str.length() == 0 || str.trim().length() == 0) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return str;
    }
}

