/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.scheduler.AtlassianSimpleTrigger;
import com.opensymphony.util.ClassLoaderUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchedulerConfig {
    private static final Category log = Category.getInstance((Class)SchedulerConfig.class);
    public static final String SCHEDULER_LOCATION = "atlassian.scheduler.location";
    private Map jobs;
    private List triggers;

    public SchedulerConfig() {
        this("scheduler-config.xml");
    }

    public SchedulerConfig(String configFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = ClassLoaderUtil.getResource((String)configFile, this.getClass());
            if (fileUrl == null) {
                throw new IllegalArgumentException("No such XML file:" + configFile);
            }
            Document doc = factory.newDocumentBuilder().parse(fileUrl.toString());
            Element root = doc.getDocumentElement();
            this.loadJobs(root);
            this.loadTriggers(root);
        }
        catch (Exception e) {
            log.error((Object)("Could not create scheduler: " + e));
        }
    }

    private void loadJobs(Element root) throws ClassNotFoundException {
        NodeList jobEls = XMLUtils.getSingleChildElement((Element)root, (String)"jobs").getElementsByTagName("job");
        this.jobs = new HashMap();
        for (int i = 0; i < jobEls.getLength(); ++i) {
            Element jobEl = (Element)jobEls.item(i);
            String name = jobEl.getAttribute("name");
            String clazz = jobEl.getAttribute("class");
            String group = XMLUtils.getAttributeWithDefault((Element)jobEl, (String)"group", (String)"DEFAULT");
            JobDetail jobDetail = new JobDetail(name, group, ClassLoaderUtils.loadClass((String)clazz, this.getClass()), true, true, false);
            this.jobs.put(jobDetail.getFullName(), jobDetail);
        }
    }

    private void loadTriggers(Element root) throws Exception {
        NodeList triggerEls = root.getElementsByTagName("trigger");
        this.triggers = new ArrayList();
        for (int i = 0; i < triggerEls.getLength(); ++i) {
            Element triggerEl = (Element)triggerEls.item(i);
            String type = XMLUtils.getAttributeWithDefault((Element)triggerEl, (String)"type", (String)"simple");
            String name = triggerEl.getAttribute("name");
            String group = XMLUtils.getAttributeWithDefault((Element)triggerEl, (String)"group", (String)"DEFAULT");
            String jobname = triggerEl.getAttribute("job");
            String jobgroup = XMLUtils.getAttributeWithDefault((Element)triggerEl, (String)"jobgroup", (String)"DEFAULT");
            long startDelay = 0L;
            if (XMLUtils.getSingleChildElement((Element)triggerEl, (String)"startDelay") != null) {
                String startDelayStr = XMLUtils.getContainedText((Node)triggerEl, (String)"startDelay");
                startDelay = DateUtils.getDuration((String)startDelayStr) * 1000L;
            }
            Object trigger = null;
            Date start = new Date(System.currentTimeMillis() + startDelay);
            if ("cron".equalsIgnoreCase(type)) {
                trigger = new CronTrigger(name, group, jobname, jobgroup, start, null, XMLUtils.getContainedText((Node)triggerEl, (String)"expression"));
                trigger.setVolatility(true);
            } else {
                int repeat = SimpleTrigger.REPEAT_INDEFINITELY;
                if (XMLUtils.getSingleChildElement((Element)triggerEl, (String)"repeat") != null) {
                    repeat = Integer.parseInt(XMLUtils.getContainedText((Node)triggerEl, (String)"repeat"));
                }
                long period = DateUtils.getDuration((String)XMLUtils.getContainedText((Node)triggerEl, (String)"period")) * 1000L;
                try {
                    trigger = new AtlassianSimpleTrigger(name, group, jobname, jobgroup, start, null, repeat, period);
                    trigger.setVolatility(true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.triggers.add(trigger);
        }
    }

    public Map getJobs() {
        return this.jobs;
    }

    public List getTriggers() {
        return this.triggers;
    }
}

