/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.velocity.util.introspection.ClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorBase {
    private final ConcurrentMap<Class<?>, ClassMap> classMethodMaps = CopyOnWriteMap.newHashMap();
    private final Set<String> cachedClassNames = new CopyOnWriteArraySet<String>();

    public Method getMethod(Class<?> c, String name, Object[] params) {
        if (c == null) {
            throw new NullPointerException("Introspector.getMethod(): Class method key was null: " + name);
        }
        return this.getClassMap(c).findMethod(name, params);
    }

    private ClassMap getClassMap(Class<?> c) {
        ClassMap classMap = (ClassMap)this.classMethodMaps.get(c);
        while (classMap == null) {
            classMap = this.createClassMap(c);
        }
        return classMap;
    }

    private ClassMap createClassMap(Class<?> c) {
        ClassMap oldClassMap;
        if (this.cachedClassNames.contains(c.getName())) {
            this.clearCache();
        }
        if ((oldClassMap = this.classMethodMaps.putIfAbsent(c, new ClassMap(c))) == null) {
            this.cachedClassNames.add(c.getName());
        }
        return (ClassMap)this.classMethodMaps.get(c);
    }

    protected void clearCache() {
        this.classMethodMaps.clear();
        this.cachedClassNames.clear();
    }
}

