/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.runtime.RuntimeLogger;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private final RuntimeLogger rlog;

    public Introspector(RuntimeLogger logger) {
        this.rlog = logger;
    }

    @Override
    public Method getMethod(Class<?> c, String name, Object[] params) {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            String msg = "Introspection Error : Ambiguous method invocation " + name + "( ";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + params[i].getClass().getName();
            }
            msg = msg + ") for class " + c;
            this.rlog.error(msg);
            return null;
        }
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.rlog.info(CACHEDUMP_MSG);
    }
}

