/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] array;
    private int pos;
    private final int size;

    public ArrayIterator(T[] array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Programmer error : internal ArrayIterator invoked w/o array");
        }
        this.array = array;
        this.pos = 0;
        this.size = Array.getLength(this.array);
    }

    @Override
    public T next() {
        if (this.pos < this.size) {
            Object result = Array.get(this.array, this.pos++);
            return (T)result;
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.size);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

