/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class ClasspathResourceLoader
extends ResourceLoader {
    private final ConcurrentMap<String, URL> urls = CopyOnWriteMap.newHashMap();

    public void init(ExtendedProperties configuration) {
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("No template name provided");
        }
        try {
            URL url = (URL)this.urls.get(name);
            while (url == null) {
                URL resource = this.getClass().getClassLoader().getResource(name);
                if (resource == null) {
                    throw new ResourceNotFoundException("Template not found:" + name);
                }
                this.urls.putIfAbsent(name, resource);
                url = (URL)this.urls.get(name);
            }
            return url.openStream();
        }
        catch (RuntimeException e) {
            throw new ResourceNotFoundException(e);
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

