/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.AvalonLogSystem;
import org.apache.velocity.runtime.log.LogSystem;

public class LogManager {
    public static LogSystem createLogSystem(RuntimeServices rsvc) throws Exception {
        Object o = rsvc.getProperty("runtime.log.logsystem");
        if (o != null && o instanceof LogSystem) {
            ((LogSystem)o).init(rsvc);
            return (LogSystem)o;
        }
        ArrayList<Object> classes = null;
        Object obj = rsvc.getProperty("runtime.log.logsystem.class");
        if (obj instanceof List) {
            classes = (ArrayList<Object>)obj;
        } else if (obj instanceof String) {
            classes = new ArrayList<Object>();
            classes.add(obj);
        }
        for (String string : classes) {
            if (string == null || string.length() <= 0) continue;
            rsvc.info("Trying to use logger class " + string);
            try {
                o = Class.forName(string).newInstance();
                if (o instanceof LogSystem) {
                    ((LogSystem)o).init(rsvc);
                    rsvc.info("Using logger class " + string);
                    return (LogSystem)o;
                }
                rsvc.error("The specifid logger class " + string + " isn't a valid LogSystem");
            }
            catch (NoClassDefFoundError ncdfe) {
                rsvc.debug("Couldn't find class " + string + " or necessary supporting classes in " + "classpath. Exception : " + ncdfe);
            }
        }
        AvalonLogSystem als = null;
        try {
            als = new AvalonLogSystem();
            als.init(rsvc);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String errstr = "PANIC : Velocity cannot find any of the specified or default logging systems in the classpath, or the classpath doesn't contain the necessary classes to support them. Please consult the documentation regarding logging. Exception : " + noClassDefFoundError;
            System.out.println(errstr);
            System.err.println(errstr);
            throw noClassDefFoundError;
        }
        rsvc.info("Using AvalonLogSystem as logger of final resort.");
        return als;
    }
}

