/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.statcvs.util.RegexpUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class FilePatternMatcher {
    private List patterns = new ArrayList();

    public FilePatternMatcher(String wildcardPattern) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        StringTokenizer tokenizer = new StringTokenizer(wildcardPattern, ":;");
        while (tokenizer.hasMoreTokens()) {
            try {
                this.patterns.add(perl5Compiler.compile(this.buildRegex(tokenizer.nextToken())));
            }
            catch (MalformedPatternException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public boolean matches(String filename) {
        Perl5Matcher matcher = new Perl5Matcher();
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern regex = (Pattern)it.next();
            if (!matcher.matches(filename, regex)) continue;
            return true;
        }
        return false;
    }

    private String buildRegex(String wildcardPattern) {
        String temp = wildcardPattern;
        if ((temp = temp.replace('\\', '/')).endsWith("/")) {
            temp = temp + "**";
        }
        if ("**".equals(temp = RegexpUtils.replaceAll(temp, "\\*\\*/\\*\\*", "**"))) {
            return ".*";
        }
        if (temp.startsWith("**/") && temp.endsWith("/**")) {
            String inner = temp.substring(3, temp.length() - 3);
            return "(.*/)?" + this.buildInnerRegex(inner) + "(/.*)?";
        }
        if (temp.startsWith("**/")) {
            String inner = temp.substring(3);
            return "(.*/)?" + this.buildInnerRegex(inner);
        }
        if (temp.endsWith("/**")) {
            String inner = temp.substring(0, temp.length() - 3);
            return this.buildInnerRegex(inner) + "(/.*)?";
        }
        return this.buildInnerRegex(temp);
    }

    private String buildInnerRegex(String wildcardPattern) {
        int pos = wildcardPattern.indexOf("/**/");
        if (pos > -1) {
            String before = wildcardPattern.substring(0, pos);
            String after = wildcardPattern.substring(pos + 4);
            return this.buildInnerRegex(before) + "/(.*/)?" + this.buildInnerRegex(after);
        }
        String result = RegexpUtils.replaceAll(wildcardPattern, "\\?", "[^/]");
        return RegexpUtils.replaceAll(result, "\\*", "[^/]*");
    }
}

