/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.util.StringTokenizer;
import net.sf.statcvs.input.LogSyntaxException;

public class CvsLogUtils {
    private static final String RCS_FILE_ENDING = ",v";
    private static boolean countLines = true;

    public static boolean isInAttic(String rcsFilename, String workingFilename) {
        int lastDelim = workingFilename.lastIndexOf("/");
        String filename = workingFilename.substring(lastDelim + 1, workingFilename.length());
        int rcsPathLength = rcsFilename.length() - filename.length() - 2;
        String rcsPath = rcsFilename.substring(0, rcsPathLength);
        return rcsPath.endsWith("/Attic/");
    }

    public static boolean isOnMainBranch(String revisionNumber) {
        int index = 0;
        int dotCount = 0;
        while (revisionNumber.indexOf(46, index) != -1) {
            index = revisionNumber.indexOf(46, index) + 1;
            ++dotCount;
        }
        return dotCount == 1;
    }

    public static String getModuleName(String rcsFilename, String workingFilename) {
        String cvsroot;
        int lastSlash;
        int localLenght = workingFilename.length() + RCS_FILE_ENDING.length();
        if (CvsLogUtils.isInAttic(rcsFilename, workingFilename)) {
            localLenght += "/Attic".length();
        }
        if ((lastSlash = (cvsroot = rcsFilename.substring(0, rcsFilename.length() - localLenght - 1)).lastIndexOf("/")) == -1) {
            return "";
        }
        return cvsroot.substring(lastSlash + 1);
    }

    public static boolean isBinaryKeywordSubst(String kws) {
        if ("kv".equals(kws)) {
            return false;
        }
        if ("kvl".equals(kws)) {
            return false;
        }
        if ("k".equals(kws)) {
            return false;
        }
        if ("o".equals(kws)) {
            return false;
        }
        if ("b".equals(kws)) {
            return true;
        }
        if ("v".equals(kws)) {
            return false;
        }
        if ("u".equals(kws)) {
            return false;
        }
        throw new IllegalArgumentException("unknown keyword substitution: " + kws);
    }

    public static String getWorkingFileName(String root, String rcsFileName) throws LogSyntaxException {
        if (!rcsFileName.endsWith(RCS_FILE_ENDING)) {
            throw new LogSyntaxException("The RCS file name must end with ',v'");
        }
        if (rcsFileName.startsWith(root + "/")) {
            return rcsFileName.substring((root + "/").length(), rcsFileName.length() - RCS_FILE_ENDING.length());
        }
        throw new LogSyntaxException("RCS filename '" + rcsFileName + "' does not start with the provided root '" + root + "'");
    }

    public static boolean isBranch(String revisionNumber) {
        StringTokenizer revisionParts = new StringTokenizer(revisionNumber, ".");
        String lastPart = null;
        String part = null;
        while (revisionParts.hasMoreTokens()) {
            lastPart = part;
            part = revisionParts.nextToken();
        }
        try {
            if (lastPart != null && Integer.parseInt(lastPart) == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    public static String calculateBranchNumber(String revisionNumber) throws LogSyntaxException {
        int index = revisionNumber.lastIndexOf(".");
        if (index > 0) {
            return revisionNumber.substring(0, index);
        }
        throw new LogSyntaxException("Cannot calculate branch revision from '" + revisionNumber + "'");
    }

    public static void setCountLines(boolean countLines) {
        CvsLogUtils.countLines = countLines;
    }

    public static boolean countLines() {
        return countLines;
    }
}

