/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Comparator;
import java.util.Iterator;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;

public class FilesRevisionCountComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        CvsFile file1 = (CvsFile)o1;
        CvsFile file2 = (CvsFile)o2;
        if (file1.getRevisions().size() < file2.getRevisions().size()) {
            return 2;
        }
        if (file1.getRevisions().size() > file2.getRevisions().size()) {
            return -2;
        }
        int lines1 = 0;
        Iterator it = file1.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            lines1 += rev.getNewLines();
        }
        int lines2 = 0;
        it = file2.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            lines2 += rev.getNewLines();
        }
        if (lines1 < lines2) {
            return 1;
        }
        if (lines1 > lines2) {
            return -1;
        }
        return 0;
    }
}

