/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.reportmodel.TimeLine;

public class FileCountTimeLineReport {
    private TimeLine timeLine = new TimeLine(Messages.getString("FILE_COUNT_TITLE"), Messages.getString("RANGE_FILES"));

    public FileCountTimeLineReport(SortedSet files) {
        this.timeLine.setInitialValue(0);
        Iterator filesIt = files.iterator();
        while (filesIt.hasNext()) {
            CvsFile file = (CvsFile)filesIt.next();
            this.addRevisions(file);
        }
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }

    private void addRevisions(CvsFile file) {
        Iterator it = file.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            int change = rev.getFileCountDelta();
            if (change == 0) continue;
            this.timeLine.addChange(rev.getDate(), change);
        }
    }
}

