/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Collection;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.reportmodel.GenericColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.RatioColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.util.IntegerMap;

public abstract class AbstractLocTableReport {
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_LINES = 1;
    private CvsContent content;
    private IntegerMap changesMap = new IntegerMap();
    private IntegerMap linesMap = new IntegerMap();

    public AbstractLocTableReport(CvsContent content) {
        this.content = content;
    }

    protected void calculateChangesAndLinesPerAuthor(Collection revs) {
        Iterator it = revs.iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            if (rev.getAuthor() == null) continue;
            this.changesMap.addInt(rev.getAuthor(), 1);
            this.linesMap.addInt(rev.getAuthor(), rev.getNewLines());
        }
    }

    protected void calculateChangesAndLinesPerDirectory(Collection revisions) {
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Directory dir = rev.getFile().getDirectory();
            this.changesMap.addInt(dir, 1);
            this.linesMap.addInt(dir, rev.getNewLines());
        }
    }

    protected Table createChangesAndLinesTable(GenericColumn keys, int sortedBy, String summary) {
        Table result = new Table(summary);
        IntegerColumn changes = new IntegerColumn(Messages.getString("COLUMN_CHANGES"));
        IntegerColumn linesOfCode = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        RatioColumn linesPerChange = new RatioColumn(Messages.getString("COLUMN_LOC_PER_CHANGE"), linesOfCode, changes);
        keys.setTotal(Messages.getString("TOTALS"));
        changes.setShowPercentages(true);
        linesOfCode.setShowPercentages(true);
        result.addColumn(keys);
        result.addColumn(changes);
        result.addColumn(linesOfCode);
        result.addColumn(linesPerChange);
        result.setKeysInFirstColumn(true);
        Iterator it = sortedBy == 0 ? this.linesMap.iteratorSortedByKey() : this.linesMap.iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Object key = it.next();
            keys.addValue(key);
            changes.addValue(this.changesMap.get(key));
            linesOfCode.addValue(this.linesMap.get(key));
        }
        if (result.getRowCount() > 1) {
            result.setShowTotals(true);
        }
        return result;
    }

    protected CvsContent getContent() {
        return this.content;
    }

    protected IntegerMap getChangesMap() {
        return this.changesMap;
    }

    protected IntegerMap getLinesMap() {
        return this.linesMap;
    }
}

