/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.util.Iterator;
import net.sf.statcvs.renderer.HTMLTableCellRenderer;
import net.sf.statcvs.reportmodel.Column;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.util.OutputUtils;

public class TableRenderer {
    private Table table;
    private HTMLTableCellRenderer renderer = new HTMLTableCellRenderer();

    public TableRenderer(Table table) {
        this.table = table;
    }

    public String getRenderedTable() {
        String result = "  <table rules=\"groups\" summary=\"" + OutputUtils.escapeHtml(this.table.getSummary()) + "\">\n";
        result = result + this.getColumnDescriptions();
        result = result + this.getTableHead();
        if (this.table.showTotals()) {
            result = result + this.getTableTotals();
        }
        result = result + this.getTableBody();
        result = result + "  </table>\n\n";
        return result;
    }

    private String getColumnDescriptions() {
        String result = "";
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            it.next();
            if (this.table.hasKeysInFirstColumn() && isFirstColumn) {
                result = result + "    <colgroup align=\"left\">\n";
                isFirstColumn = false;
                continue;
            }
            result = result + "    <colgroup align=\"right\">\n";
        }
        return result;
    }

    private String getTableHead() {
        String result = "    <thead>\n      <tr>\n";
        Iterator it = this.table.getColumnIterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderHead(this.renderer);
            result = result + "        " + this.renderer.getColumnHead() + "\n";
        }
        result = result + "      </tr>\n    </thead>\n";
        return result;
    }

    private String getTableTotals() {
        String result = "    <tfoot>\n      <tr>\n";
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderTotal(this.renderer);
            if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                result = result + "        " + this.renderer.getRowHead() + "\n";
                isFirstColumn = false;
                continue;
            }
            result = result + "        " + this.renderer.getTableCell() + "\n";
        }
        result = result + "      </tr>\n    </tfoot>\n";
        return result;
    }

    private String getTableBody() {
        String result = "    <tbody>\n";
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            result = result + this.getTableRow(i);
        }
        result = result + "    </tbody>\n";
        return result;
    }

    private String getTableRow(int rowIndex) {
        String result = rowIndex % 2 == 0 ? "      <tr class=\"odd\">\n" : "      <tr class=\"even\">\n";
        Iterator it = this.table.getColumnIterator();
        boolean isFirstColumn = true;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.renderCell(rowIndex, this.renderer);
            if (isFirstColumn && this.table.hasKeysInFirstColumn()) {
                result = result + "        " + this.renderer.getRowHead() + "\n";
                isFirstColumn = false;
                continue;
            }
            result = result + "        " + this.renderer.getTableCell() + "\n";
        }
        result = result + "      </tr>\n";
        return result;
    }
}

