/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import net.sf.statcvs.util.IntegerMap;
import net.sf.statcvs.util.OutputUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;

public class PieChart
extends Chart {
    private static final int SLICE_MIN_PERCENT = 5;
    public static final int FILTERED_BY_REPOSITORY = 0;
    public static final int FILTERED_BY_USER = 1;

    public PieChart(CvsContent content, String title, String fileName, Author author, int filter) {
        super(title, fileName);
        DefaultPieDataset data = new DefaultPieDataset();
        ArrayList directories = filter == 1 ? new ArrayList(author.getDirectories()) : new ArrayList(content.getDirectories());
        Collections.sort(directories);
        IntegerMap dirSizes = new IntegerMap();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            if (filter == 1) {
                dirSizes.addInt(dir, this.getLineValueOfAuthorInDir(author, dir));
                continue;
            }
            dirSizes.addInt(dir, this.getLOCInDir(dir));
        }
        int otherSum = 0;
        ArrayList<Color> colors = new ArrayList<Color>();
        ArrayList<Color> outlines = new ArrayList<Color>();
        it = dirSizes.iteratorSortedByValue();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            if (dirSizes.getPercent(dir) >= 5.0) {
                String dirName = dir.isRoot() ? "/" : dir.getPath();
                data.setValue((Comparable)((Object)dirName), (Number)dirSizes.getInteger(dir));
                colors.add(OutputUtils.getStringColor(dirName));
                outlines.add(Color.black);
                continue;
            }
            otherSum += dirSizes.get(dir);
        }
        data.setValue((Comparable)((Object)Messages.getString("PIE_MODSIZE_OTHER")), (Number)new Integer(otherSum));
        colors.add(Color.gray);
        outlines.add(Color.black);
        this.setChart(ChartFactory.createPieChart3D((String)ConfigurationOptions.getProjectName(), (PieDataset)data, (boolean)false, (boolean)false, (boolean)false));
        PiePlot plot = (PiePlot)this.getChart().getPlot();
        plot.setForegroundAlpha(0.6f);
        for (int i = 0; i < colors.size(); ++i) {
            plot.setSectionPaint(i, (Paint)colors.get(i));
        }
        for (int j = 0; j < outlines.size(); ++j) {
            plot.setSectionOutlinePaint(j, (Paint)outlines.get(j));
        }
        this.createChart();
        this.saveChart(640, 480);
    }

    private int getLineValueOfAuthorInDir(Author author, Directory dir) {
        int result = 0;
        Iterator it = dir.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            if (!author.equals(rev.getAuthor())) continue;
            result += rev.getNewLines();
        }
        return result;
    }

    private int getLOCInDir(Directory dir) {
        int result = 0;
        Iterator fileIt = dir.getFiles().iterator();
        while (fileIt.hasNext()) {
            CvsFile element = (CvsFile)fileIt.next();
            result += element.getCurrentLinesOfCode();
        }
        return result;
    }
}

