/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import net.sf.statcvs.util.OutputUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYStepRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class LOCChart
extends Chart {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs.renderer.LOCChart");

    public LOCChart(TimeSeries locSeries, String title, String fileName, int width, int height) {
        super(title, fileName);
        Paint[] colors = new Paint[]{Color.blue};
        TimeSeriesCollection collection = new TimeSeriesCollection();
        collection.addSeries(locSeries);
        this.createLOCChart(collection, colors, title);
        this.createChart();
        this.saveChart(width, height);
    }

    public LOCChart(List locSeriesList, String title, String fileName, int width, int height) {
        super(title, fileName);
        Paint[] colors = new Paint[locSeriesList.size()];
        int i = 0;
        TimeSeriesCollection collection = new TimeSeriesCollection();
        Iterator it = locSeriesList.iterator();
        while (it.hasNext()) {
            TimeSeries series = (TimeSeries)it.next();
            collection.addSeries(series);
            colors[i] = OutputUtils.getStringColor(series.getName());
            ++i;
        }
        this.createLOCChart(collection, colors, title);
        this.createChart();
        this.saveChart(width, height);
    }

    private void createLOCChart(TimeSeriesCollection collection, Paint[] colors, String title) {
        logger.debug((Object)("creating LOC chart for " + title));
        String domain = Messages.getString("TIME_LOC_DOMAIN");
        String range = Messages.getString("TIME_LOC_RANGE");
        TimeSeriesCollection data = collection;
        boolean legend = collection.getSeriesCount() > 1;
        this.setChart(ChartFactory.createTimeSeriesChart((String)ConfigurationOptions.getProjectName(), (String)domain, (String)range, (XYDataset)data, (boolean)legend, (boolean)false, (boolean)false));
        XYPlot plot = this.getChart().getXYPlot();
        for (int i = 0; i < colors.length; ++i) {
            plot.getRenderer().setSeriesPaint(0, colors[i]);
        }
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        domainAxis.setVerticalTickLabels(true);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLowerBound(0.0);
        plot.setRenderer((XYItemRenderer)new XYStepRenderer());
    }
}

