/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.statcvs.util.IntegerMap;

public class FileCollectionFormatter {
    private Collection files;
    private IntegerMap filesPerDir;
    private IntegerMap dirDepths;

    public FileCollectionFormatter(Collection files) {
        this.files = files;
        this.filesPerDir = this.createFilesPerDirCount();
        this.dirDepths = this.createDirDepths();
    }

    private IntegerMap createFilesPerDirCount() {
        IntegerMap result = new IntegerMap();
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            result.addInt(FileCollectionFormatter.getDirectory(file), 1);
        }
        return result;
    }

    private IntegerMap createDirDepths() {
        IntegerMap result = new IntegerMap();
        Iterator it = this.filesPerDir.iteratorSortedByKey();
        while (it.hasNext()) {
            String dir = (String)it.next();
            result.put(dir, FileCollectionFormatter.getDepth(dir));
        }
        return result;
    }

    public List getDirectories() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.dirDepths.iteratorSortedByKey();
        while (it.hasNext()) {
            String directory = (String)it.next();
            result.add(directory);
        }
        return result;
    }

    public List getFiles(String directory) {
        if (!this.dirDepths.contains(directory)) {
            throw new NoSuchElementException("doesn't contain directory '" + directory + "'");
        }
        ArrayList result = new ArrayList(this.getFilesInDir(directory));
        Collections.sort(result);
        List allSubdirFiles = this.getFilesInSubdirs(directory);
        Collections.sort(allSubdirFiles);
        result.addAll(allSubdirFiles);
        return result;
    }

    private List getFilesInSubdirs(String directory) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            if (!FileCollectionFormatter.isInDirectory(filename, directory) || FileCollectionFormatter.getDirectory(filename).equals(directory) || this.isInDeeperDirectory(filename, directory)) continue;
            result.add(FileCollectionFormatter.getRelativeFilename(filename, directory));
        }
        return result;
    }

    private boolean isInDeeperDirectory(String filename, String directory) {
        String currentDir = FileCollectionFormatter.getDirectory(filename);
        int directoryDepth = FileCollectionFormatter.getDepth(directory);
        for (int currentDepth = FileCollectionFormatter.getDepth(currentDir); currentDepth > directoryDepth; --currentDepth) {
            if (this.dirDepths.contains(currentDir)) {
                return true;
            }
            currentDir = FileCollectionFormatter.getParent(currentDir);
        }
        return false;
    }

    private List getFilesInDir(String directory) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            if (!FileCollectionFormatter.getDirectory(filename).equals(directory)) continue;
            result.add(FileCollectionFormatter.getRelativeFilename(filename, directory));
        }
        return result;
    }

    protected static boolean isInDirectory(String filename, String directory) {
        return FileCollectionFormatter.getDirectory(filename).startsWith(directory);
    }

    protected static String getRelativeFilename(String filename, String dir) {
        return filename.substring(dir.length());
    }

    protected static String getDirectory(String filename) {
        return filename.substring(0, filename.lastIndexOf("/") + 1);
    }

    protected static String getParent(String directory) {
        int lastIndex = directory.lastIndexOf("/");
        if (lastIndex == -1) {
            return "";
        }
        return directory.substring(0, directory.lastIndexOf("/", lastIndex - 1) + 1);
    }

    protected static int getDepth(String directory) {
        int result = 0;
        int index = 0;
        while (directory.indexOf("/", index) != -1) {
            index = directory.indexOf("/", index) + 1;
            ++result;
        }
        return result;
    }
}

