/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import net.sf.statcvs.renderer.PointXYRenderer;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class CombinedCommitScatterChart
extends Chart {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs.renderer.LOCChart");

    public CombinedCommitScatterChart(TimeSeries series_all, Map authorSeriesMap, String title, String fileName, int width, int height) {
        super(title, fileName);
        this.createScatterChart(series_all, authorSeriesMap, title);
        this.createChart();
        this.saveChart(width, height);
    }

    private void createScatterChart(TimeSeries series_all, Map authorSeriesMap, String title) {
        logger.debug((Object)("creating scatter chart for " + title));
        String domain = Messages.getString("TIME_CSC_DOMAIN");
        String range = Messages.getString("TIME_CSC_RANGE");
        DateAxis timeAxis = new DateAxis(domain);
        timeAxis.setVerticalTickLabels(true);
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        JFreeChart chart = new JFreeChart(ConfigurationOptions.getProjectName(), JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)combinedPlot, false);
        this.setChart(chart);
        TimeSeriesCollection dataset_all = new TimeSeriesCollection(series_all);
        NumberAxis valueAxis_all = new NumberAxis("All (" + range + ")");
        valueAxis_all.setTickUnit(new NumberTickUnit(6.0, (NumberFormat)new DecimalFormat("0")));
        valueAxis_all.setAutoRangeIncludesZero(false);
        valueAxis_all.setRange(0.0, 24.0);
        valueAxis_all.setLabelFont(new Font("SansSerif", 0, 9));
        PointXYRenderer renderer = new PointXYRenderer(1, (XYToolTipGenerator)new StandardXYItemLabelGenerator(DateFormat.getInstance()));
        renderer.setShape(new Rectangle(new Dimension(2, 2)));
        XYPlot plot_all = new XYPlot((XYDataset)dataset_all, null, (ValueAxis)valueAxis_all, (XYItemRenderer)renderer);
        combinedPlot.add(plot_all, 1);
        ArrayList authors = new ArrayList(authorSeriesMap.keySet());
        Collections.sort(authors);
        Iterator authorsIt = authors.iterator();
        while (authorsIt.hasNext()) {
            Author author = (Author)authorsIt.next();
            TimeSeries timeSeries = (TimeSeries)authorSeriesMap.get(author);
            TimeSeriesCollection dataset = new TimeSeriesCollection(timeSeries);
            NumberAxis valueAxis = new NumberAxis(author.getName());
            valueAxis.setTickUnit(new NumberTickUnit(6.0, (NumberFormat)new DecimalFormat("0")));
            valueAxis.setAutoRangeIncludesZero(false);
            valueAxis.setRange(0.0, 24.0);
            valueAxis.setLabelFont(new Font("SansSerif", 0, 9));
            PointXYRenderer renderer1 = new PointXYRenderer(1, (XYToolTipGenerator)new StandardXYItemLabelGenerator(DateFormat.getInstance()));
            renderer1.setShape(new Rectangle(new Dimension(2, 2)));
            XYPlot plot1 = new XYPlot((XYDataset)dataset, null, (ValueAxis)valueAxis, (XYItemRenderer)renderer1);
            plot1.getRenderer().setSeriesPaint(0, (Paint)Color.red);
            combinedPlot.add(plot1, 1);
        }
        combinedPlot.setGap(10.0);
        this.setChart(chart);
    }
}

