/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import net.sf.statcvs.output.ConfigurationOptions;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.Spacer;

public class Chart {
    private static Logger logger = Logger.getLogger((String)"sf.net.statcvs.renderer.ChartRenderer");
    private String title;
    private String fileName;
    private Font font = new Font("SansSerif", 0, 12);
    private JFreeChart chart;

    public Chart(String title, String fileName) {
        this.title = title;
        this.fileName = fileName;
    }

    public void createChart() {
        this.addTitles();
        this.chart.setBackgroundPaint((Paint)new Color(204, 204, 187));
    }

    public void saveChart(int imageWidth, int imageHeight, String filename) {
        String oldFileName = this.fileName;
        this.fileName = filename;
        this.saveChart(imageWidth, imageHeight);
        this.fileName = oldFileName;
    }

    public void saveChart(int imageWidth, int imageHeight) {
        try {
            ChartUtilities.saveChartAsPNG((File)new File(ConfigurationOptions.getOutputDir() + this.fileName), (JFreeChart)this.chart, (int)imageWidth, (int)imageHeight);
            logger.debug((Object)("saved chart '" + this.title + "' as '" + this.fileName + "'"));
        }
        catch (IOException e) {
            logger.warn((Object)("Could not save Chart as png Image: " + this.fileName + e.toString()));
        }
    }

    private void addTitles() {
        TextTitle title2 = new TextTitle(this.title, this.font);
        title2.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
        this.chart.addSubtitle((Title)title2);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public String getFileName() {
        return this.fileName;
    }
}

