/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;

public class BarChart
extends Chart {
    private double[] categories;

    public BarChart(SortedSet revisions, String title, String fileName, int categoryCount, String[] categoryNames) {
        super(title, fileName);
        this.categories = new double[categoryCount];
        for (int i = 0; i < this.categories.length; ++i) {
            this.categories[i] = 0.0;
        }
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            int hour;
            CvsRevision rev = (CvsRevision)it.next();
            Date date = rev.getDate();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            if (categoryCount == 7) {
                int day = cal.get(7);
                int n = day - 1;
                this.categories[n] = this.categories[n] + 1.0;
                continue;
            }
            if (categoryCount != 24) continue;
            int n = hour = cal.get(11);
            this.categories[n] = this.categories[n] + 1.0;
        }
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        for (int i = 0; i < categoryCount; ++i) {
            data.addValue(this.categories[i], (Comparable)((Object)"Commits"), (Comparable)((Object)categoryNames[i]));
        }
        this.setChart(ChartFactory.createBarChart((String)ConfigurationOptions.getProjectName(), (String)"", (String)"commits", (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false));
        CategoryPlot plot = this.getChart().getCategoryPlot();
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
        this.createChart();
        this.saveChart(500, 300);
    }
}

