/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import net.sf.statcvs.model.CvsRevision;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class LOCSeriesBuilder {
    private TimeSeries series;
    private boolean hasRevisions = false;
    private Minute minute;
    private int loc = 0;
    private boolean finished = false;
    private boolean countEffective;
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    public LOCSeriesBuilder(String seriesTitle, boolean countEffective) {
        this.series = new TimeSeries(seriesTitle, class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = LOCSeriesBuilder.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        this.countEffective = countEffective;
    }

    public void addRevision(CvsRevision revision) {
        if (this.finished) {
            throw new IllegalStateException("can't add more revisions after getTimeSeries()");
        }
        if (!this.hasRevisions) {
            if (revision.isBeginOfLog()) {
                this.loc += revision.getLines();
                return;
            }
            this.minute = new Minute(revision.getDate());
            this.series.add(this.minute.previous(), (double)this.loc);
            this.hasRevisions = true;
        } else {
            Minute currentMinute = new Minute(revision.getDate());
            if (!currentMinute.equals((Object)this.minute)) {
                this.series.add((RegularTimePeriod)this.minute, (double)this.loc);
                this.minute = currentMinute;
            }
        }
        this.loc = this.countEffective ? (this.loc += revision.getLinesDelta()) : (this.loc += revision.getNewLines());
    }

    public TimeSeries getTimeSeries() {
        if (!this.hasRevisions) {
            return null;
        }
        if (!this.finished) {
            this.series.add((RegularTimePeriod)this.minute, (double)this.loc);
            this.series.add(this.minute.next(), (double)this.loc);
            this.finished = true;
        }
        return this.series;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

