/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLOutput;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.renderer.CommitLogRenderer;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TopAuthorsTableReport;

public class IndexPage
extends HTMLPage {
    private static SimpleDateFormat outputDateFormat = new SimpleDateFormat(Messages.getString("DATE_FORMAT"));
    private boolean locImageCreated;
    private boolean commitScatterImageCreated;
    private boolean authorsPageCreated;

    public IndexPage(CvsContent content, boolean locImageCreated, boolean commitScatterImageCreated, boolean authorsPageCreated) throws IOException {
        super(content);
        this.locImageCreated = locImageCreated;
        this.commitScatterImageCreated = commitScatterImageCreated;
        this.authorsPageCreated = authorsPageCreated;
        this.setFileName("index.html");
        this.setPageName(Messages.getString("INDEX_TITLE") + " " + ConfigurationOptions.getProjectName());
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.print(this.getProjectInfo());
        if (ConfigurationOptions.getNotes() != null) {
            this.print(ConfigurationOptions.getNotes());
        }
        this.print(this.getReportNavigation());
        this.print(this.getLOC());
        if (this.authorsPageCreated) {
            this.print(this.getTopAuthorsSection());
        }
        this.printH2(Messages.getString("REPTREE_TITLE"));
        this.printParagraph(this.getIndexTree());
    }

    private String getProjectInfo() {
        Calendar cal = Calendar.getInstance();
        String result = HTMLTagger.getSummaryPeriod(this.getContent().getFirstDate(), this.getContent().getLastDate(), this.br() + "Generated: " + outputDateFormat.format(cal.getTime()));
        return result;
    }

    private String getReportNavigation() {
        String authorLink;
        if (this.authorsPageCreated) {
            authorLink = this.a("authors.html", Messages.getString("CPU_TITLE"));
        } else {
            Author author = this.getOnlyAuthor();
            String caption = Messages.getString("NAVIGATION_AUTHOR") + " " + author.getName();
            authorLink = this.a(HTMLOutput.getAuthorPageFilename(author), caption);
        }
        return this.ul(this.li(authorLink) + this.li(this.a(CommitLogRenderer.getFilename(1), Messages.getString("COMMIT_LOG_TITLE"))) + this.li(this.a("loc.html", Messages.getString("LOC_TITLE"))) + this.li(this.a("file_sizes.html", Messages.getString("FILE_SIZES_TITLE"))) + this.li(this.a("dir_sizes.html", Messages.getString("DIRECTORY_SIZES_TITLE"))));
    }

    private String getLOC() {
        if (!this.locImageCreated || !this.commitScatterImageCreated) {
            return "";
        }
        String result = this.h2(Messages.getString("LOC_TITLE"));
        int loc = this.getContent().getCurrentLOC();
        result = result + this.p(this.a("loc.html", this.img("loc_small.png", 400, 300)) + this.br() + this.strong("Total Lines Of Code:") + " " + loc + " (" + HTMLTagger.getDateAndTime(this.getContent().getLastDate()) + ")");
        return result;
    }

    private String getTopAuthorsSection() {
        TopAuthorsTableReport report = new TopAuthorsTableReport(this.getContent());
        report.calculate();
        Table table = report.getTable();
        String result = table.getRowCount() >= 10 ? this.h2(Messages.getString("SECTION_TOP_AUTHORS")) : this.h2(Messages.getString("SECTION_AUTHORS"));
        result = result + new TableRenderer(table).getRenderedTable();
        result = result + this.p(this.a("authors.html", Messages.getString("NAVIGATION_MORE")));
        return result;
    }

    private String getIndexTree() throws FileNotFoundException, IOException {
        String result = "";
        Iterator it = this.getContent().getDirectories().iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            result = result + this.getFolderHtml(dir, 0);
        }
        return result;
    }

    private Author getOnlyAuthor() {
        return (Author)this.getContent().getAuthors().iterator().next();
    }
}

