/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLOutput;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class HTMLTagger {
    private static SimpleDateFormat outputDateFormat = new SimpleDateFormat(Messages.getString("DATE_FORMAT"));
    private static SimpleDateFormat outputDateTimeFormat = new SimpleDateFormat(Messages.getString("DATE_TIME_FORMAT"));

    public static String getLink(String link, String linkName) {
        return "<a href=\"" + link + "\">" + linkName + "</a>";
    }

    public static String getAuthorLink(Author author) {
        return "<a href=\"" + HTMLOutput.getAuthorPageFilename(author) + "\" class=\"author\">" + author.getName() + "</a>";
    }

    public static String getDate(Date date) {
        return "<span class=\"date\">" + outputDateFormat.format(date) + "</span>";
    }

    public static String getDateAndTime(Date date) {
        return "<span class=\"date\">" + outputDateTimeFormat.format(date) + "</span>";
    }

    public static String getDirectoryLink(Directory directory) {
        String caption = directory.isRoot() ? "/" : directory.getPath();
        return "<a href=\"" + HTMLOutput.getDirectoryPageFilename(directory) + "\" class=\"directory\">" + caption + "</a>";
    }

    public static String getFileLink(CvsFile file) {
        WebRepositoryIntegration wri = ConfigurationOptions.getWebRepository();
        if (wri == null) {
            return file.getFilenameWithPath();
        }
        return "<a href=\"" + wri.getFileViewUrl(file) + "\">" + file.getFilenameWithPath() + "</a>";
    }

    public static String getSummaryPeriod(Date startDate, Date endDate) {
        return HTMLTagger.getSummaryPeriod(startDate, endDate, "");
    }

    public static String getSummaryPeriod(Date startDate, Date endDate, String additionalText) {
        return "<p class=\"summaryperiod\">\n  " + Messages.getString("SUMMARY_PERIOD") + ":\n  " + HTMLTagger.getDate(startDate) + " to\n  " + HTMLTagger.getDate(endDate) + " " + additionalText + "\n</p>\n";
    }

    public static String getIcon(String iconFilename) {
        return "<img src=\"" + iconFilename + "\" width=\"" + 15 + "\" height=\"" + 13 + "\">";
    }
}

