/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.FileWriter;
import java.io.IOException;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLOutput;
import net.sf.statcvs.output.HTMLTagger;
import org.apache.log4j.Logger;

public abstract class HTMLPage {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs.output.HTMLPage");
    protected static final int SPACE_COUNT = 4;
    private FileWriter htmlFileWriter;
    private CvsContent content;
    private String fileName;
    private String pageName;

    public HTMLPage(CvsContent content) {
        this.content = content;
    }

    protected void createPage() throws IOException {
        logger.info((Object)("Creating page '" + this.getPageName() + "'"));
        this.initFileWriter();
        this.printHeader();
        this.printHeadline();
        this.printBody();
        this.printFooter();
    }

    protected void print(String printStream) throws IOException {
        this.htmlFileWriter.write(printStream);
    }

    private void initFileWriter() throws IOException {
        this.htmlFileWriter = new FileWriter(ConfigurationOptions.getOutputDir() + this.getFileName());
    }

    private void printHeader() throws IOException {
        this.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n<html>\n  <head>\n    <title>" + Messages.getString("PROJECT_SHORTNAME") + " - " + this.getPageName() + "</title>\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; " + "charset=ISO-8859-1\">\n" + "    <meta name=\"Generator\" content=\"StatCvs " + Messages.getString("CVS_VERSION_TAG") + "\">\n" + "    <link rel=\"stylesheet\" href=\"" + ConfigurationOptions.getCssHandler().getLink() + "\" type=\"text/css\">\n" + "  </head>\n\n" + "<body>\n");
    }

    private void printHeadline() throws IOException {
        this.print(this.h1(this.getPageName()));
    }

    protected void printH2(String h2) throws IOException {
        this.print(this.h2(h2));
    }

    private void printFooter() throws IOException {
        this.print("<div id=\"generatedby\">");
        this.printParagraph(Messages.getString("PAGE_GENERATED_BY") + " " + this.a("http://statcvs.sf.net", Messages.getString("PROJECT_SHORTNAME")) + " " + Messages.getString("CVS_VERSION_TAG"));
        this.print("</div>\n");
        this.print("</body>\n");
        this.print("</html>");
        this.htmlFileWriter.close();
    }

    protected void printParagraph(String paragraphContent) throws IOException {
        this.print(this.p(paragraphContent));
    }

    protected void printBackLink() throws IOException {
        this.print(this.p(this.a("index.html", Messages.getString("NAVIGATION_BACK"))));
    }

    protected String br() {
        return "<br>\n";
    }

    protected String p(String p) {
        return this.tag("p", p);
    }

    protected String h1(String h1) {
        return "\n\n" + this.tag("h1", h1) + "\n";
    }

    protected String h2(String h2) {
        return "\n" + this.tag("h2", h2) + "\n";
    }

    protected String strong(String b) {
        return this.tag("strong", b);
    }

    protected String a(String target, String html) {
        return "<a href=\"" + target + "\">" + html + "</a>";
    }

    protected String ul(String ul) {
        return this.tag("ul", ul);
    }

    protected String li(String li) {
        return this.tag("li", li);
    }

    protected String img(String image, int width, int height) {
        return "<img src=\"" + image + "\" width=\"" + width + "\" height=\"" + height + "\" alt=\"\">";
    }

    protected String img(String image) {
        return "<img src=\"" + image + "\" alt=\"\">";
    }

    protected String tag(String elementName, String elementContent) {
        return "<" + elementName + ">" + elementContent + "</" + elementName + ">\n";
    }

    protected abstract void printBody() throws IOException;

    public String getUserLink(String userName) {
        return this.a("user_" + userName + ".html", userName);
    }

    private String getSpaces(int count) {
        String result = "";
        for (int i = 0; i < count * 4; ++i) {
            result = result + "&nbsp;";
        }
        return result;
    }

    protected String deleteEndingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String getFolderHtml(Directory dir, int currentDepth) {
        String name = dir.isRoot() ? Messages.getString("NAVIGATION_ROOT") : dir.getName();
        String result = this.getSpaces(dir.getDepth() - currentDepth);
        result = dir.isEmpty() ? result + HTMLTagger.getIcon("folder-deleted.png") : result + HTMLTagger.getIcon("folder.png");
        String pageFilename = HTMLOutput.getDirectoryPageFilename(dir);
        result = result + " \n" + this.a(pageFilename, name);
        result = result + " \n(" + dir.getCurrentFileCount() + " ";
        result = result + Messages.getString("DIRECTORY_TREE_FILES") + ", ";
        result = result + dir.getCurrentLOC() + " ";
        result = result + Messages.getString("DIRECTORY_TREE_LINES") + ")" + this.br() + "\n";
        return result;
    }

    public static Logger getLogger() {
        return logger;
    }

    protected CvsContent getContent() {
        return this.content;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected void setPageName(String pageName) {
        this.pageName = pageName;
    }

    protected String getPageName() {
        return this.pageName;
    }
}

