/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.AuthorPage;
import net.sf.statcvs.output.CPAPage;
import net.sf.statcvs.output.CommitLogPage;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.DirectorySizesPage;
import net.sf.statcvs.output.FileSizesPage;
import net.sf.statcvs.output.IndexPage;
import net.sf.statcvs.output.LOCPage;
import net.sf.statcvs.output.LOCSeriesBuilder;
import net.sf.statcvs.output.ModulePage;
import net.sf.statcvs.output.NoFilesPage;
import net.sf.statcvs.renderer.BarChart;
import net.sf.statcvs.renderer.CombinedCommitScatterChart;
import net.sf.statcvs.renderer.CommitLogRenderer;
import net.sf.statcvs.renderer.LOCChart;
import net.sf.statcvs.renderer.PieChart;
import net.sf.statcvs.renderer.StackedBarChart;
import net.sf.statcvs.renderer.TimeLineChart;
import net.sf.statcvs.reportmodel.TimeLine;
import net.sf.statcvs.reports.AvgFileSizeTimeLineReport;
import net.sf.statcvs.reports.FileCountTimeLineReport;
import net.sf.statcvs.util.FileUtils;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class HTMLOutput {
    public static final String WEB_FILE_PATH = "web-files/";
    public static final String DIRECTORY_ICON = "folder.png";
    public static final String DELETED_DIRECTORY_ICON = "folder-deleted.png";
    public static final String FILE_ICON = "file.png";
    public static final String DELETED_FILE_ICON = "file-deleted.png";
    public static final int ICON_WIDTH = 15;
    public static final int ICON_HEIGHT = 13;
    public static final int MOST_RECENT_COMMITS_LENGTH = 20;
    public static final int IMAGE_WIDTH = 640;
    public static final int IMAGE_HEIGHT = 480;
    public static final int SMALL_IMAGE_WIDTH = 500;
    public static final int SMALL_IMAGE_HEIGHT = 300;
    public static final int LOC_IMAGE_WIDTH = 400;
    public static final int LOC_IMAGE_HEIGHT = 300;
    private String[] categoryNamesHours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private String[] categoryNamesDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private CvsContent content;
    static /* synthetic */ Class class$net$sf$statcvs$Main;
    static /* synthetic */ Class class$org$jfree$data$time$Second;

    public HTMLOutput(CvsContent content) {
        this.content = content;
    }

    public void createHTMLSuite() throws IOException {
        ConfigurationOptions.getCssHandler().createOutputFiles();
        if (this.content.isEmpty()) {
            new NoFilesPage(this.content);
            return;
        }
        this.createIcon(DIRECTORY_ICON);
        this.createIcon(DELETED_DIRECTORY_ICON);
        this.createIcon(FILE_ICON);
        this.createIcon(DELETED_FILE_ICON);
        boolean authorsPageCreated = this.content.getAuthors().size() > 1;
        boolean locImageCreated = this.createLOCChart();
        boolean commitScatterImageCreated = this.createCommitScatterChartPerAuthor();
        this.createFileCountChart();
        this.createModuleSizesChart();
        if (authorsPageCreated) {
            this.createActivityChart(this.content.getRevisions(), Messages.getString("ACTIVITY_TIME_TITLE"), "activity_time.png", this.categoryNamesHours);
            this.createActivityChart(this.content.getRevisions(), Messages.getString("ACTIVITY_DAY_TITLE"), "activity_day.png", this.categoryNamesDays);
            this.createAuthorActivityChart();
            boolean locPerAuthorImageCreated = this.createLOCPerAuthorChart();
            new CPAPage(this.content, 1, locPerAuthorImageCreated);
            new CPAPage(this.content, 0, locPerAuthorImageCreated);
        }
        new IndexPage(this.content, locImageCreated, commitScatterImageCreated, authorsPageCreated);
        new LOCPage(this.content, locImageCreated);
        new FileSizesPage(this.content);
        new DirectorySizesPage(this.content);
        this.createModulePagesAndCharts();
        this.createCommitLogPages();
        this.createAuthorPages();
    }

    private void createAuthorActivityChart() {
        new StackedBarChart(this.content, Messages.getString("AUTHOR_ACTIVITY_TITLE"), "activity.png");
    }

    public static String getDirectoryPageFilename(Directory directory) {
        return "module" + HTMLOutput.escapeDirectoryName(directory.getPath()) + ".html";
    }

    public static String getDirectoryLocChartFilename(Directory directory) {
        return "loc_module" + HTMLOutput.escapeDirectoryName(directory.getPath()) + ".png";
    }

    public static String getAuthorPageFilename(Author author) {
        return "user_" + HTMLOutput.escapeAuthorName(author.getName()) + ".html";
    }

    public static String getActivityTimeChartFilename(Author author) {
        return "activity_time_" + HTMLOutput.escapeAuthorName(author.getName()) + ".png";
    }

    public static String getActivityDayChartFilename(Author author) {
        return "activity_day_" + HTMLOutput.escapeAuthorName(author.getName()) + ".png";
    }

    public static String getCodeDistributionChartFilename(Author author) {
        return "module_sizes_" + HTMLOutput.escapeAuthorName(author.getName()) + ".png";
    }

    private static String escapeDirectoryName(String directoryName) {
        if (!directoryName.startsWith("/")) {
            directoryName = "/" + directoryName;
        }
        return directoryName.substring(0, directoryName.length() - 1).replace('/', '_');
    }

    private static String escapeAuthorName(String authorName) {
        return authorName.replace('#', '_');
    }

    private void createIcon(String iconFilename) throws IOException {
        FileUtils.copyFile((class$net$sf$statcvs$Main == null ? (class$net$sf$statcvs$Main = HTMLOutput.class$("net.sf.statcvs.Main")) : class$net$sf$statcvs$Main).getResourceAsStream(WEB_FILE_PATH + iconFilename), new File(ConfigurationOptions.getOutputDir() + iconFilename));
    }

    private boolean createLOCChart() {
        String subtitle = Messages.getString("TIME_LOC_SUBTITLE");
        TimeSeries series = this.getLOCTimeSeries(this.content.getRevisions(), subtitle);
        if (series == null) {
            return false;
        }
        new LOCChart(series, subtitle, "loc.png", 640, 480);
        new LOCChart(series, subtitle, "loc_small.png", 400, 300);
        return true;
    }

    private boolean createCommitScatterChartPerAuthor() {
        String subtitle = Messages.getString("TIME_CSC_SUBTITLE");
        Iterator it_all = this.content.getRevisions().iterator();
        TimeSeries series_all = new TimeSeries("Test", class$org$jfree$data$time$Second == null ? (class$org$jfree$data$time$Second = HTMLOutput.class$("org.jfree.data.time.Second")) : class$org$jfree$data$time$Second);
        Date lastDate_all = new Date();
        while (it_all.hasNext()) {
            Calendar cal;
            CvsRevision rev = (CvsRevision)it_all.next();
            if (lastDate_all != null) {
                cal = Calendar.getInstance();
                cal.setTime(lastDate_all);
                double lastDateSeconds = cal.get(13);
                cal.setTime(rev.getDate());
                double dateSeconds = cal.get(13);
                if (lastDateSeconds == dateSeconds) continue;
            }
            lastDate_all = rev.getDate();
            cal = Calendar.getInstance();
            cal.setTime(lastDate_all);
            double hour = cal.get(11);
            double minutes = cal.get(12);
            series_all.add((RegularTimePeriod)new Second(lastDate_all), hour + minutes / 60.0);
        }
        if (series_all == null) {
            return false;
        }
        Iterator authorsIt = this.content.getAuthors().iterator();
        HashMap<Author, TimeSeries> authorSeriesMap = new HashMap<Author, TimeSeries>();
        while (authorsIt.hasNext()) {
            Author author = (Author)authorsIt.next();
            Iterator it = author.getRevisions().iterator();
            TimeSeries series = new TimeSeries("Test", class$org$jfree$data$time$Second == null ? HTMLOutput.class$("org.jfree.data.time.Second") : class$org$jfree$data$time$Second);
            Date lastDate = new Date();
            while (it.hasNext()) {
                Calendar cal;
                CvsRevision rev = (CvsRevision)it.next();
                if (lastDate != null) {
                    cal = Calendar.getInstance();
                    cal.setTime(lastDate);
                    double lastDateSeconds = cal.get(13);
                    cal.setTime(rev.getDate());
                    double dateSeconds = cal.get(13);
                    if (lastDateSeconds == dateSeconds) continue;
                }
                lastDate = rev.getDate();
                cal = Calendar.getInstance();
                cal.setTime(lastDate);
                double hour = cal.get(11);
                double minutes = cal.get(12);
                series.add((RegularTimePeriod)new Second(lastDate), hour + minutes / 60.0);
            }
            if (series == null) {
                return false;
            }
            authorSeriesMap.put(author, series);
        }
        new CombinedCommitScatterChart(series_all, authorSeriesMap, subtitle, "commitscatterauthors.png", 640, 70 * (authorSeriesMap.size() + 1) + 110);
        return true;
    }

    private void createModulePagesAndCharts() throws IOException {
        Iterator it = this.content.getDirectories().iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            boolean moduleImageCreated = this.createLOCChart(dir);
            new ModulePage(this.content, dir, moduleImageCreated);
        }
    }

    private void createAuthorPages() throws IOException {
        SortedSet authors = this.content.getAuthors();
        Iterator it = authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            this.createActivityChart(author.getRevisions(), Messages.getString("ACTIVITY_TIME_FOR_AUTHOR_TITLE") + " " + author.getName(), HTMLOutput.getActivityTimeChartFilename(author), this.categoryNamesHours);
            this.createActivityChart(author.getRevisions(), Messages.getString("ACTIVITY_DAY_FOR_AUTHOR_TITLE") + " " + author.getName(), HTMLOutput.getActivityDayChartFilename(author), this.categoryNamesDays);
            boolean chartCreated = this.createCodeDistributionChart(author);
            new AuthorPage(this.content, author, chartCreated);
        }
    }

    private void createCommitLogPages() throws IOException {
        List commits = this.content.getCommits();
        CommitLogRenderer logRenderer = new CommitLogRenderer(commits);
        int pages = logRenderer.getPages();
        for (int i = 1; i <= pages; ++i) {
            new CommitLogPage(this.content, logRenderer, i, pages);
        }
    }

    private boolean createLOCChart(Directory dir) {
        String subtitle = Messages.getString("TIME_LOC_SUBTITLE");
        TimeSeries series = this.getLOCTimeSeries(dir.getRevisions(), subtitle);
        if (series == null) {
            return false;
        }
        String fileName = HTMLOutput.getDirectoryLocChartFilename(dir);
        new LOCChart(series, dir.getPath() + " " + subtitle, fileName, 640, 480);
        return true;
    }

    private TimeSeries getLOCTimeSeries(SortedSet revisions, String title) {
        Iterator it = revisions.iterator();
        LOCSeriesBuilder locCounter = new LOCSeriesBuilder(title, true);
        while (it.hasNext()) {
            locCounter.addRevision((CvsRevision)it.next());
        }
        return locCounter.getTimeSeries();
    }

    private void createFileCountChart() {
        SortedSet files = this.content.getFiles();
        TimeLine fileCount = new FileCountTimeLineReport(files).getTimeLine();
        new TimeLineChart(fileCount, "file_count.png", 640, 480);
        TimeLine avgFileSize = new AvgFileSizeTimeLineReport(files).getTimeLine();
        new TimeLineChart(avgFileSize, "file_size.png", 640, 480);
    }

    private void createModuleSizesChart() {
        new PieChart(this.content, Messages.getString("PIE_MODSIZE_SUBTITLE"), "module_sizes.png", null, 0);
    }

    private void createActivityChart(SortedSet revisions, String title, String fileName, String[] categoryNames) {
        new BarChart(revisions, title, fileName, categoryNames.length, categoryNames);
    }

    private boolean createLOCPerAuthorChart() {
        Iterator authorsIt = this.content.getAuthors().iterator();
        HashMap<Author, LOCSeriesBuilder> authorSeriesMap = new HashMap<Author, LOCSeriesBuilder>();
        while (authorsIt.hasNext()) {
            Author author = (Author)authorsIt.next();
            authorSeriesMap.put(author, new LOCSeriesBuilder(author.getName(), false));
        }
        Iterator allRevs = this.content.getRevisions().iterator();
        while (allRevs.hasNext()) {
            CvsRevision rev = (CvsRevision)allRevs.next();
            if (rev.isBeginOfLog()) continue;
            LOCSeriesBuilder builder = (LOCSeriesBuilder)authorSeriesMap.get(rev.getAuthor());
            builder.addRevision(rev);
        }
        ArrayList authors = new ArrayList(authorSeriesMap.keySet());
        Collections.sort(authors);
        ArrayList<TimeSeries> seriesList = new ArrayList<TimeSeries>();
        authorsIt = authors.iterator();
        while (authorsIt.hasNext()) {
            Author author = (Author)authorsIt.next();
            LOCSeriesBuilder builder = (LOCSeriesBuilder)authorSeriesMap.get(author);
            TimeSeries series = builder.getTimeSeries();
            if (series == null) continue;
            seriesList.add(series);
        }
        if (seriesList.isEmpty()) {
            return false;
        }
        String subtitle = Messages.getString("TIME_LOCPERAUTHOR_SUBTITLE");
        new LOCChart(seriesList, subtitle, "loc_per_author.png", 640, 480);
        return true;
    }

    private boolean createCodeDistributionChart(Author author) {
        Iterator it = author.getRevisions().iterator();
        int totalLinesOfCode = 0;
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            totalLinesOfCode += rev.getNewLines();
        }
        if (totalLinesOfCode == 0) {
            return false;
        }
        new PieChart(this.content, Messages.getString("PIE_CODEDISTRIBUTION_SUBTITLE") + " " + author.getName(), HTMLOutput.getCodeDistributionChartFilename(author), author, 1);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

