/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reports.FilesWithMostRevisionsTableReport;
import net.sf.statcvs.reports.LargestFilesTableReport;

public class FileSizesPage
extends HTMLPage {
    private static final int MAX_LARGEST_FILES = 20;
    private static final int MAX_FILES_WITH_MOST_REVISIONS = 20;

    public FileSizesPage(CvsContent content) throws IOException {
        super(content);
        this.setFileName("file_sizes.html");
        this.setPageName(Messages.getString("FILE_SIZES_TITLE"));
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        this.print(this.h2(Messages.getString("FILE_COUNT_TITLE")));
        this.print(this.getFileCountImage());
        this.print(this.h2(Messages.getString("AVERAGE_FILE_SIZE_TITLE")));
        this.print(this.getFileSizeImage());
        this.print(this.getLargestFilesSection());
        this.print(this.getFilesWithMostRevisionsSection());
    }

    private String getLargestFilesSection() {
        String result = "";
        result = result + this.h2(Messages.getString("LARGEST_FILES_TITLE"));
        LargestFilesTableReport report = new LargestFilesTableReport(this.getContent().getFiles(), 20);
        report.calculate();
        result = result + new TableRenderer(report.getTable()).getRenderedTable();
        return result;
    }

    private String getFilesWithMostRevisionsSection() {
        String result = "";
        result = result + this.h2(Messages.getString("FILES_WITH_MOST_REVISIONS_TITLE"));
        FilesWithMostRevisionsTableReport report = new FilesWithMostRevisionsTableReport(this.getContent().getFiles(), 20);
        report.calculate();
        result = result + new TableRenderer(report.getTable()).getRenderedTable();
        return result;
    }

    private String getFileCountImage() {
        int fileCount = this.getCurrentFileCount();
        String result = this.img("file_count.png", 640, 480) + this.br() + this.strong(Messages.getString("TOTAL_FILE_COUNT") + ": ") + fileCount;
        result = result + " (" + HTMLTagger.getDateAndTime(this.getContent().getLastDate()) + ")";
        return this.p(result);
    }

    private String getFileSizeImage() {
        return this.p(this.img("file_size.png", 640, 480));
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator fileIt = this.getContent().getFiles().iterator();
        while (fileIt.hasNext()) {
            CvsFile file = (CvsFile)fileIt.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }
}

