/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.HashSet;
import java.util.Set;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class CvswebIntegration
implements WebRepositoryIntegration {
    private String baseURL;
    private Set atticFileNames = new HashSet();

    public CvswebIntegration(String baseURL) {
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "cvsweb";
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseURL + "/" + directory.getPath();
    }

    public String getFileHistoryUrl(CvsFile file) {
        if (this.isInAttic(file)) {
            String path = file.getDirectory().getPath();
            String filename = file.getFilename();
            return this.baseURL + "/" + path + "Attic/" + filename;
        }
        return this.baseURL + "/" + file.getFilenameWithPath();
    }

    public String getFileViewUrl(CvsFile file) {
        return this.getFileHistoryUrl(file) + "?rev=HEAD&content-type=text/vnd.viewcvs-markup";
    }

    public String getFileViewUrl(CvsRevision revision) {
        return this.getFileHistoryUrl(revision.getFile()) + "?rev=" + revision.getRevisionNumber() + "&content-type=text/vnd.viewcvs-markup";
    }

    public String getDiffUrl(CvsRevision oldRevision, CvsRevision newRevision) {
        if (!oldRevision.getFile().equals(newRevision.getFile())) {
            throw new IllegalArgumentException("revisions must be of the same file");
        }
        return this.getFileHistoryUrl(oldRevision.getFile()) + ".diff?r1=" + oldRevision.getRevisionNumber() + "&r2=" + newRevision.getRevisionNumber() + "&f=h";
    }

    public void setAtticFileNames(Set atticFileNames) {
        this.atticFileNames = atticFileNames;
    }

    private boolean isInAttic(CvsFile file) {
        return this.atticFileNames.contains(file.getFilenameWithPath());
    }
}

