/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.statcvs.output.ChoraIntegration;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.CssHandler;
import net.sf.statcvs.output.CvswebIntegration;
import net.sf.statcvs.output.DefaultCssHandler;
import net.sf.statcvs.output.LocalFileCssHandler;
import net.sf.statcvs.output.UrlCssHandler;
import net.sf.statcvs.output.ViewCvsIntegration;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.FileUtils;

public class ConfigurationOptions {
    private static final String LOGGING_CONFIG_DEFAULT = "log4j.properties";
    private static final String LOGGING_CONFIG_VERBOSE = "log4j-verbose.properties";
    private static final String LOGGING_CONFIG_DEBUG = "log4j-debug.properties";
    private static String logFileName = null;
    private static String checkedOutDirectory = null;
    private static String projectName = null;
    private static String outputDir = "";
    private static String loggingProperties = "log4j.properties";
    private static String notesFile = null;
    private static String notes = null;
    private static FilePatternMatcher includePattern = null;
    private static FilePatternMatcher excludePattern = null;
    private static CssHandler cssHandler = new DefaultCssHandler("statcvs.css");
    private static WebRepositoryIntegration webRepository = null;

    public static CssHandler getCssHandler() {
        return cssHandler;
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getCheckedOutDirectory() {
        return checkedOutDirectory;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static String getOutputDir() {
        return outputDir;
    }

    public static String getNotes() {
        return notes;
    }

    public static WebRepositoryIntegration getWebRepository() {
        return webRepository;
    }

    public static void setCheckedOutDirectory(String checkedOutDirectory) throws ConfigurationException {
        File directory = new File(checkedOutDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConfigurationException("directory does not exist: " + checkedOutDirectory);
        }
        ConfigurationOptions.checkedOutDirectory = checkedOutDirectory;
    }

    public static void setCssFile(String cssFile) throws ConfigurationException {
        try {
            URL url = new URL(cssFile);
            if (!url.getProtocol().equals("http")) {
                throw new ConfigurationException("Only HTTP URLs or local files allowed for -css");
            }
            cssHandler = new UrlCssHandler(url);
        }
        catch (MalformedURLException isLocalFile) {
            cssHandler = new LocalFileCssHandler(cssFile);
        }
        cssHandler.checkForMissingResources();
    }

    public static void setLogFileName(String logFileName) throws ConfigurationException {
        File inputFile = new File(logFileName);
        if (!inputFile.exists()) {
            throw new ConfigurationException("Specified logfile not found: " + logFileName);
        }
        ConfigurationOptions.logFileName = logFileName;
    }

    public static void setOutputDir(String outputDir) throws ConfigurationException {
        File outDir;
        if (!outputDir.endsWith(FileUtils.getDirSeparator())) {
            outputDir = outputDir + FileUtils.getDefaultDirSeparator();
        }
        if (!(outDir = new File(outputDir)).exists() && !outDir.mkdirs()) {
            throw new ConfigurationException("Can't create output directory: " + outputDir);
        }
        ConfigurationOptions.outputDir = outputDir;
    }

    public static void setNotesFile(String notesFile) throws ConfigurationException {
        File f = new File(notesFile);
        if (!f.exists()) {
            throw new ConfigurationException("Notes file not found: " + notesFile);
        }
        if (!f.canRead()) {
            throw new ConfigurationException("Can't read notes file: " + notesFile);
        }
        ConfigurationOptions.notesFile = notesFile;
        try {
            notes = ConfigurationOptions.readNotesFile();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void setViewCvsURL(String url) {
        webRepository = new ViewCvsIntegration(url);
    }

    public static void setCvswebURL(String url) {
        webRepository = new CvswebIntegration(url);
    }

    public static void setChoraURL(String url) {
        webRepository = new ChoraIntegration(url);
    }

    public static void setProjectName(String projectName) {
        ConfigurationOptions.projectName = projectName;
    }

    public static String getLoggingProperties() {
        return loggingProperties;
    }

    public static void setVerboseLogging() {
        loggingProperties = LOGGING_CONFIG_VERBOSE;
    }

    public static void setDebugLogging() {
        loggingProperties = LOGGING_CONFIG_DEBUG;
    }

    private static String readNotesFile() throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(notesFile));
        String line = r.readLine();
        String result = "";
        while (line != null) {
            result = result + line;
            line = r.readLine();
        }
        return result;
    }

    public static void setIncludePattern(String patternList) {
        includePattern = new FilePatternMatcher(patternList);
    }

    public static void setExcludePattern(String patternList) {
        excludePattern = new FilePatternMatcher(patternList);
    }

    public static FilePatternMatcher getExcludePattern() {
        return excludePattern;
    }

    public static FilePatternMatcher getIncludePattern() {
        return includePattern;
    }
}

