/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.output.HTMLOutput;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.renderer.CommitLogRenderer;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.DirectoriesForAuthorTableReport;
import org.apache.log4j.Logger;

public class AuthorPage
extends HTMLPage {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs.output.UserPage");
    private Author author;
    private boolean codeDistributionChartCreated;
    private int userChangeCount = 0;
    private int userLineCount = 0;
    private int totalChangeCount = 0;
    private int totalLineCount = 0;

    public AuthorPage(CvsContent content, Author author, boolean codeDistributionChartCreated) throws IOException {
        super(content);
        this.author = author;
        this.codeDistributionChartCreated = codeDistributionChartCreated;
        this.setFileName(HTMLOutput.getAuthorPageFilename(author));
        this.setPageName("User statistics for " + author.getName());
        logger.debug((Object)("creating author page for '" + author.getName() + "'"));
        this.totalChangeCount = this.getContent().getRevisions().size();
        this.totalLineCount = this.getLineValue(this.getContent().getRevisions());
        this.userChangeCount = author.getRevisions().size();
        this.userLineCount = this.getLineValue(author.getRevisions());
        this.createPage();
    }

    private int getLineValue(Collection revisions) {
        int result = 0;
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            CvsRevision element = (CvsRevision)it.next();
            result += element.getNewLines();
        }
        return result;
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        this.print(this.getAuthorInfo());
        if (this.totalChangeCount > 0) {
            this.print(this.getChangesSection());
        }
        if (this.totalLineCount > 0) {
            this.print(this.getLinesOfCodeSection());
        }
        this.print(this.getModulesSection());
        this.print(this.getActivitySection());
        this.print(this.getLastCommits());
    }

    private String getActivitySection() {
        String result = "";
        result = result + this.h2(Messages.getString("ACTIVITY_TITLE"));
        result = result + this.p(this.img(HTMLOutput.getActivityTimeChartFilename(this.author), 500, 300));
        result = result + this.p(this.img(HTMLOutput.getActivityDayChartFilename(this.author), 500, 300));
        return result;
    }

    private String getAuthorInfo() {
        CvsRevision firstRev = (CvsRevision)this.author.getRevisions().first();
        CvsRevision lastRev = (CvsRevision)this.author.getRevisions().last();
        return HTMLTagger.getSummaryPeriod(firstRev.getDate(), lastRev.getDate());
    }

    private String getChangesSection() {
        String result = this.h2("Total Changes");
        String percentage = this.getPercentage(this.totalChangeCount, this.userChangeCount);
        result = result + this.p(this.userChangeCount + " (" + percentage + ")");
        return result;
    }

    private String getLinesOfCodeSection() {
        if (this.totalLineCount == 0) {
            return "";
        }
        String result = this.h2(Messages.getString("LOC_TITLE"));
        result = result + this.p(this.userLineCount + " (" + this.getPercentage(this.totalLineCount, this.userLineCount) + ")");
        return result;
    }

    private String getModulesSection() {
        String result = this.h2("Modules");
        if (this.codeDistributionChartCreated) {
            result = result + this.p(this.img(HTMLOutput.getCodeDistributionChartFilename(this.author), 640, 480));
        }
        DirectoriesForAuthorTableReport report = new DirectoriesForAuthorTableReport(this.getContent(), this.author);
        report.calculate();
        Table table = report.getTable();
        result = result + new TableRenderer(table).getRenderedTable();
        return result;
    }

    private String getLastCommits() {
        String result = this.h2(Messages.getString("MOST_RECENT_COMMITS"));
        ArrayList<Commit> authorCommits = new ArrayList<Commit>();
        Iterator it = this.getContent().getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            if (!this.author.equals(commit.getAuthor())) continue;
            authorCommits.add(commit);
        }
        CommitLogRenderer renderer = new CommitLogRenderer(authorCommits);
        result = result + renderer.renderMostRecentCommits(20);
        return result;
    }

    private String getPercentage(int totalCount, int count) {
        int percentTimes10 = count * 1000 / totalCount;
        double percent = (double)percentTimes10 / 10.0;
        return Double.toString(percent) + "%";
    }
}

