/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import net.sf.statcvs.input.BranchData;
import net.sf.statcvs.util.CvsLogUtils;

public class RevisionData {
    private String revisionNumber;
    private Date date;
    private String loginName;
    private boolean stateExp = false;
    private boolean stateDead = false;
    private boolean hasNoLines = true;
    private int linesAdded;
    private int linesRemoved;
    private String comment;
    private BranchData mainBranchData;
    private Collection startBranches = Collections.EMPTY_SET;

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String authorName) {
        this.loginName = authorName;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getLinesAdded() {
        return this.linesAdded;
    }

    public int getLinesRemoved() {
        return this.linesRemoved;
    }

    public boolean hasNoLines() {
        return this.hasNoLines;
    }

    public void setLines(int added, int removed) {
        this.linesAdded = added;
        this.linesRemoved = removed;
        this.hasNoLines = false;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(String revision) {
        this.revisionNumber = revision;
    }

    public void setStateDead() {
        this.stateDead = true;
    }

    public void setStateExp() {
        this.stateExp = true;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAddOnSubbranch() {
        return this.stateDead && this.revisionNumber.equals("1.1");
    }

    public boolean isDeletion() {
        return this.stateDead && !this.revisionNumber.equals("1.1");
    }

    public boolean isChangeOrRestore() {
        return this.stateExp && !this.hasNoLines;
    }

    public boolean isCreation() {
        return this.stateExp && this.hasNoLines;
    }

    public boolean isOnTrunk() {
        return CvsLogUtils.isOnMainBranch(this.revisionNumber);
    }

    public boolean hasMainBranchData() {
        return this.getMainBranchData() != null;
    }

    public boolean isStateExp() {
        return this.stateExp;
    }

    public boolean isStateDead() {
        return this.stateDead;
    }

    public String toString() {
        return "RevisionData " + this.revisionNumber;
    }

    public Collection getStartBranches() {
        return this.startBranches;
    }

    public void setStartBranches(Collection startBranches) {
        this.startBranches = startBranches;
    }

    public BranchData getMainBranchData() {
        return this.mainBranchData;
    }

    public void setMainBranchData(BranchData mainBranchData) {
        this.mainBranchData = mainBranchData;
    }
}

