/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.statcvs.input.BranchData;
import net.sf.statcvs.input.Builder;
import net.sf.statcvs.input.NoBranchException;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.model.CvsBranch;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.util.CvsLogUtils;
import org.apache.log4j.Logger;

public class FileBuilder {
    private static Logger logger = Logger.getLogger((String)(class$net$sf$statcvs$input$FileBuilder == null ? (class$net$sf$statcvs$input$FileBuilder = FileBuilder.class$("net.sf.statcvs.input.FileBuilder")) : class$net$sf$statcvs$input$FileBuilder).getName());
    private Builder builder;
    private String name;
    private boolean isBinary;
    private String parseBranchName;
    private Collection branches;
    private List revisions = new ArrayList();
    private RevisionData lastAdded = null;
    static /* synthetic */ Class class$net$sf$statcvs$input$FileBuilder;

    public FileBuilder(Builder builder, String name, Collection branches, boolean isBinary, String parseBranchName) {
        this.builder = builder;
        this.branches = branches;
        this.name = name;
        this.isBinary = isBinary;
        this.parseBranchName = parseBranchName;
        logger.debug((Object)("logging " + name));
    }

    public void addRevisionData(RevisionData data) {
        if (!data.hasMainBranchData()) {
            throw new NoBranchException("RevisionData has no branch information.");
        }
        if (this.parseBranchName != null && !this.parseBranchName.equals(data.getMainBranchData().getName())) {
            return;
        }
        if (this.isBinary) {
            data.setLines(0, 0);
        }
        this.revisions.add(data);
        this.lastAdded = data;
    }

    public CvsFile createFile(Date beginOfLogDate) {
        if (this.isFilteredFile() || !this.fileExistsInLogPeriod()) {
            return null;
        }
        if (this.revisions.size() == 1 && this.lastAdded.isAddOnSubbranch()) {
            return null;
        }
        Map cvsBranches = this.createBranches();
        CvsFile file = new CvsFile(this.name, this.builder.getDirectory(this.name), cvsBranches);
        if (this.revisions.isEmpty()) {
            this.buildBeginOfLogRevision(file, beginOfLogDate, this.getFinalLOC());
            return file;
        }
        Iterator it = this.revisions.iterator();
        RevisionData currentData = (RevisionData)it.next();
        int currentLOC = this.getFinalLOC();
        int previousLOC = 0;
        RevisionData previousData = null;
        CvsRevision cvsRevision = null;
        CvsRevision previousCVSRevision = null;
        while (it.hasNext()) {
            previousData = currentData;
            previousLOC = currentLOC;
            currentData = (RevisionData)it.next();
            if (previousData.getMainBranchData().equals(currentData.getMainBranchData())) {
                if (previousData.isChangeOrRestore()) {
                    cvsRevision = currentData.isDeletion() || currentData.isAddOnSubbranch() ? this.buildCreationRevision(file, previousData, previousLOC, (CvsBranch)cvsBranches.get(previousData.getMainBranchData().getName())) : this.buildChangeRevision(file, previousData, previousLOC, (CvsBranch)cvsBranches.get(previousData.getMainBranchData().getName()));
                } else if (previousData.isDeletion()) {
                    cvsRevision = this.buildDeletionRevision(file, previousData, previousLOC, (CvsBranch)cvsBranches.get(previousData.getMainBranchData().getName()));
                } else {
                    logger.warn((Object)("illegal state in " + file.getFilenameWithPath() + ":" + previousData.getRevisionNumber()));
                }
                if (previousCVSRevision == null) {
                    cvsRevision.getMainBranch().setLastCvsRevision(cvsRevision);
                } else {
                    previousCVSRevision.setPreviousRevision(cvsRevision);
                }
                previousCVSRevision = cvsRevision;
                this.setFirstRevisionForBranches(previousData, cvsBranches, cvsRevision, file);
            } else {
                this.processFirstRevisionOnBranch(previousData, file, previousLOC, beginOfLogDate, cvsBranches, previousCVSRevision);
                previousCVSRevision = null;
            }
            if (!previousData.getMainBranchData().getName().equals("HEAD")) continue;
            currentLOC = previousLOC - this.getLOCChange(previousData);
        }
        this.processFirstRevisionOnBranch(currentData, file, currentLOC, beginOfLogDate, cvsBranches, previousCVSRevision);
        return file;
    }

    private void setFirstRevisionForBranches(RevisionData revisionData, Map cvsBranches, CvsRevision cvsRevision, CvsFile file) {
        Iterator iterator = revisionData.getStartBranches().iterator();
        while (iterator.hasNext()) {
            BranchData branchData = (BranchData)iterator.next();
            CvsBranch cvsBranch = (CvsBranch)cvsBranches.get(branchData.getName());
            if (cvsBranch != null) {
                cvsBranch.setFirstCvsRevision(cvsRevision);
                continue;
            }
            logger.warn((Object)("cannot find CVS Branch with name '" + branchData.getName() + "' for " + file.getFilenameWithPath() + ":" + revisionData.getRevisionNumber()));
        }
    }

    private Map createBranches() {
        HashMap<String, CvsBranch> branchMap = new HashMap<String, CvsBranch>();
        Iterator iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            BranchData branchData = (BranchData)iterator.next();
            branchMap.put(branchData.getName(), new CvsBranch(branchData.getName()));
        }
        CvsBranch headCvsBranch = new CvsBranch();
        branchMap.put(headCvsBranch.getName(), headCvsBranch);
        return branchMap;
    }

    private CvsRevision processFirstRevisionOnBranch(RevisionData revisionData, CvsFile file, int loc, Date beginOfLogDate, Map cvsBranches, CvsRevision previousCvsRevision) {
        CvsRevision cvsRevision = null;
        if (revisionData.isCreation()) {
            cvsRevision = this.buildCreationRevision(file, revisionData, loc, (CvsBranch)cvsBranches.get(revisionData.getMainBranchData().getName()));
        } else if (revisionData.isDeletion()) {
            cvsRevision = this.buildDeletionRevision(file, revisionData, loc, (CvsBranch)cvsBranches.get(revisionData.getMainBranchData().getName()));
            this.buildInitialRevision(cvsRevision, loc, revisionData, file, beginOfLogDate);
        } else if (revisionData.isChangeOrRestore()) {
            cvsRevision = this.buildChangeRevision(file, revisionData, loc, (CvsBranch)cvsBranches.get(revisionData.getMainBranchData().getName()));
            this.buildInitialRevision(cvsRevision, loc, revisionData, file, beginOfLogDate);
        } else if (!revisionData.isAddOnSubbranch()) {
            logger.warn((Object)("illegal state in " + file.getFilenameWithPath() + ":" + revisionData.getRevisionNumber()));
        }
        if (previousCvsRevision == null) {
            if (cvsRevision != null) {
                cvsRevision.getMainBranch().setLastCvsRevision(cvsRevision);
            }
        } else {
            previousCvsRevision.setPreviousRevision(cvsRevision);
        }
        if (cvsRevision != null) {
            cvsRevision.setPreviousRevision(cvsRevision.getMainBranch().getFirstCvsRevision());
            this.setFirstRevisionForBranches(revisionData, cvsBranches, cvsRevision, file);
        }
        return cvsRevision;
    }

    private void buildInitialRevision(CvsRevision cvsRevision, int loc, RevisionData revisionData, CvsFile file, Date beginOfLogDate) {
        if (cvsRevision.getMainBranch().getName().equals(CvsBranch.HEAD_BRANCH_NAME)) {
            int nextLinesOfCode = loc - this.getLOCChange(revisionData);
            CvsRevision initialCvsRevision = this.buildBeginOfLogRevision(file, beginOfLogDate, nextLinesOfCode);
            cvsRevision.setPreviousRevision(initialCvsRevision);
        }
    }

    private int getFinalLOC() {
        if (this.isBinary || !CvsLogUtils.countLines()) {
            return 0;
        }
        if (this.finalRevisionIsDead()) {
            return this.approximateFinalLOC();
        }
        try {
            return this.builder.getLOC(this.name);
        }
        catch (NoLineCountException e) {
            logger.warn((Object)e.getMessage());
            return this.approximateFinalLOC();
        }
    }

    private boolean finalRevisionIsDead() {
        if (this.revisions.isEmpty()) {
            return false;
        }
        return ((RevisionData)this.revisions.get(0)).isDeletion();
    }

    private int approximateFinalLOC() {
        int max = 0;
        int current = 0;
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            RevisionData data = (RevisionData)it.next();
            if (!data.getMainBranchData().getName().equals("HEAD")) continue;
            max = Math.max(current += data.getLinesAdded(), max);
            current -= data.getLinesRemoved();
        }
        return max;
    }

    private int getLOCChange(RevisionData data) {
        if (!CvsLogUtils.countLines()) {
            return 0;
        }
        return data.getLinesAdded() - data.getLinesRemoved();
    }

    private CvsBranch buildCvsBranch(BranchData branchData) {
        return new CvsBranch(branchData.getName());
    }

    private CvsRevision buildCreationRevision(CvsFile file, RevisionData data, int loc, CvsBranch mainBranch) {
        return file.addInitialRevision(mainBranch, data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc);
    }

    private CvsRevision buildChangeRevision(CvsFile file, RevisionData data, int loc, CvsBranch mainBranch) {
        return file.addChangeRevision(mainBranch, data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc, data.getLinesAdded() - data.getLinesRemoved(), Math.min(data.getLinesAdded(), data.getLinesRemoved()));
    }

    private CvsRevision buildDeletionRevision(CvsFile file, RevisionData data, int loc, CvsBranch mainBranch) {
        return file.addDeletionRevision(mainBranch, data.getRevisionNumber(), this.builder.getAuthor(data.getLoginName()), data.getDate(), data.getComment(), loc);
    }

    private CvsRevision buildBeginOfLogRevision(CvsFile file, Date beginOfLogDate, int loc) {
        Date date = new Date(beginOfLogDate.getTime() - 60000L);
        return file.addBeginOfLogRevision(date, loc);
    }

    private boolean isFilteredFile() {
        return this.name.startsWith("CVSROOT") || !this.builder.matchesPatterns(this.name);
    }

    private boolean fileExistsInLogPeriod() {
        if (this.revisions.size() > 0) {
            return true;
        }
        try {
            this.builder.getLOC(this.name);
            return true;
        }
        catch (NoLineCountException fileDoesNotExistInTimespan) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

