/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.statcvs.input.BranchData;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.util.CvsLogUtils;
import net.sf.statcvs.util.LookaheadReader;
import org.apache.log4j.Logger;

public class CvsRevisionParser {
    private static Logger logger = Logger.getLogger((String)(class$net$sf$statcvs$input$CvsRevisionParser == null ? (class$net$sf$statcvs$input$CvsRevisionParser = CvsRevisionParser.class$("net.sf.statcvs.input.CvsRevisionParser")) : class$net$sf$statcvs$input$CvsRevisionParser).getName());
    public static final String REVISION_DELIMITER = "----------------------------";
    public static final String FILE_DELIMITER = "=============================================================================";
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss zzz";
    private static final String LOG_TIMESTAMP_FORMAT_TZ = "yyyy-MM-dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private static SimpleDateFormat logTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);
    private static SimpleDateFormat logTimeFormatTZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);
    private LookaheadReader logReader;
    private CvsLogBuilder builder;
    private Collection branches;
    private boolean fileDone = false;
    private RevisionData revision;
    static /* synthetic */ Class class$net$sf$statcvs$input$CvsRevisionParser;

    public CvsRevisionParser(LookaheadReader logReader, CvsLogBuilder builder, Collection branches) {
        this.logReader = logReader;
        this.builder = builder;
        this.branches = branches;
    }

    public void parse() throws LogSyntaxException, IOException {
        if (FILE_DELIMITER.equals(this.logReader.getCurrentLine())) {
            return;
        }
        this.logReader.getNextLine();
        do {
            this.revision = new RevisionData();
            this.parseRevision();
            this.builder.buildRevision(this.revision);
        } while (!this.fileDone);
    }

    private void parseRevision() throws IOException, LogSyntaxException {
        if (!this.isNewRevisionLine(this.logReader.getCurrentLine())) {
            throw new LogSyntaxException("expected 'revision' but found '" + this.logReader.getCurrentLine() + "' in line " + this.logReader.getLineNumber());
        }
        String revNo = this.logReader.getCurrentLine().substring("revision ".length());
        this.revision.setRevisionNumber(revNo);
        this.parseDateLine(this.logReader.getNextLine());
        if (this.logReader.getNextLine().startsWith("branches:")) {
            this.logReader.getNextLine();
        }
        StringBuffer comment = new StringBuffer();
        while (true) {
            String next;
            String line;
            if (REVISION_DELIMITER.equals(line = this.logReader.getCurrentLine())) {
                next = this.logReader.getNextLine();
                if (this.isNewRevisionLine(next)) {
                    this.revision.setComment(comment.toString());
                    break;
                }
            } else if (FILE_DELIMITER.equals(line)) {
                next = this.logReader.getNextLine();
                if (next == null || "".equals(next)) {
                    this.revision.setComment(comment.toString());
                    this.fileDone = true;
                    break;
                }
            } else {
                this.logReader.getNextLine();
            }
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append(line);
        }
        this.setBranchInformation();
    }

    private void setBranchInformation() throws LogSyntaxException {
        HashSet<BranchData> matchedStartBranches = new HashSet<BranchData>();
        Iterator iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            BranchData branchData = (BranchData)iterator.next();
            if (branchData.isOnBranch(this.revision.getRevisionNumber())) {
                this.revision.setMainBranchData(branchData);
                continue;
            }
            if (!branchData.isStartRevision(this.revision.getRevisionNumber())) continue;
            matchedStartBranches.add(branchData);
        }
        if (CvsLogUtils.isOnMainBranch(this.revision.getRevisionNumber())) {
            this.revision.setMainBranchData(new BranchData());
        }
    }

    private void parseDateLine(String line) throws IOException, LogSyntaxException {
        int endOfDateIndex = line.indexOf(59, 6);
        String dateString = line.substring(6, endOfDateIndex);
        Date date = CvsRevisionParser.convertFromLogTime(dateString);
        if (date == null) {
            System.err.println("Date: " + dateString);
            throw new LogSyntaxException("unexpected date format in line " + this.logReader.getLineNumber());
        }
        this.revision.setDate(date);
        int endOfAuthorIndex = line.indexOf(59, endOfDateIndex + 1);
        this.revision.setLoginName(line.substring(endOfDateIndex + 11, endOfAuthorIndex));
        String fileState = line.substring(endOfAuthorIndex + 10, line.indexOf(59, endOfAuthorIndex + 1));
        if (this.isDeadState(fileState)) {
            this.revision.setStateDead();
            return;
        }
        this.revision.setStateExp();
        int beginOfLinesIndex = line.indexOf("lines:", endOfAuthorIndex + 1);
        if (beginOfLinesIndex < 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line.substring(beginOfLinesIndex + 8));
        int linesAdded = Integer.parseInt(st.nextToken());
        String removed = st.nextToken();
        if (removed.indexOf(59) >= 0) {
            removed = removed.substring(0, removed.indexOf(59));
        }
        int linesRemoved = -Integer.parseInt(removed);
        this.revision.setLines(linesAdded, linesRemoved);
    }

    private boolean isNewRevisionLine(String line) {
        return line.startsWith("revision ");
    }

    private boolean isDeadState(String state) throws IOException {
        if ("dead".equals(state)) {
            return true;
        }
        if ("Exp".equals(state)) {
            return false;
        }
        logger.warn((Object)("unknown file state '" + state + "' at line " + this.logReader.getLineNumber()));
        return false;
    }

    private static Date convertFromLogTime(String modTime) {
        try {
            int index = modTime.length() - 5;
            char c = modTime.charAt(index);
            if (c == '+' || c == '-') {
                return logTimeFormatTZ.parse(modTime.substring(0, index) + "GMT" + modTime.substring(index, index + 3) + ":" + modTime.substring(index + 3));
            }
            return logTimeFormat.parse(modTime + " GMT");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

