/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsRevision;

public class CommitListBuilder {
    private static final int MAX_TIME_BETWEEN_CHANGES_MILLISECONDS = 300000;
    private SortedSet revisions;
    private Map currentCommits = new HashMap();
    private List commits = new ArrayList();

    public CommitListBuilder(SortedSet revisions) {
        this.revisions = revisions;
    }

    public List createCommitList() {
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            this.processRevision((CvsRevision)it.next());
        }
        return this.commits;
    }

    protected void processRevision(CvsRevision rev) {
        if (rev.getAuthor() == null) {
            return;
        }
        Commit commit = (Commit)this.currentCommits.get(rev.getAuthor());
        if (commit == null || !CommitListBuilder.isSameCommit(commit, rev)) {
            this.addNewCommit(rev);
        } else {
            this.addRevToCommit(commit, rev);
        }
    }

    protected void addNewCommit(CvsRevision rev) {
        Commit newCommit = new Commit(rev);
        this.currentCommits.put(rev.getAuthor(), newCommit);
        this.commits.add(newCommit);
    }

    protected void addRevToCommit(Commit commit, CvsRevision rev) {
        commit.addRevision(rev);
    }

    public static boolean isSameCommit(Commit commit, CvsRevision rev) {
        return commit.getAuthor().equals(rev.getAuthor()) && commit.getComment().equals(rev.getComment()) && CommitListBuilder.isInTimeFrame(commit, rev.getDate()) && rev.getMainBranch().equals(commit.getMainBranch());
    }

    public static boolean isInTimeFrame(Commit commit, Date date) {
        return date.getTime() > commit.getDate().getTime() - 300000L && date.getTime() < commit.getDate().getTime() + 300000L;
    }
}

