/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import net.sf.statcvs.input.CommitListBuilder;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.DefaultRevisionFilter;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.FileBuilder;
import net.sf.statcvs.input.NoBranchException;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.input.RevisionData;
import net.sf.statcvs.input.RevisionFilter;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.FileUtils;
import org.apache.log4j.Logger;

public class Builder
implements CvsLogBuilder {
    private static Logger logger = Logger.getLogger((String)(class$net$sf$statcvs$input$Builder == null ? (class$net$sf$statcvs$input$Builder = Builder.class$("net.sf.statcvs.input.Builder")) : class$net$sf$statcvs$input$Builder).getName());
    private final RepositoryFileManager repositoryFileManager;
    private final FilePatternMatcher includePattern;
    private final FilePatternMatcher excludePattern;
    private final Map authors = new HashMap();
    private final Map directories = new HashMap();
    private final List fileBuilders = new ArrayList();
    private final Set atticFileNames = new HashSet();
    private FileBuilder currentFileBuilder = null;
    private Date startDate = null;
    private String projectName = null;
    private String moduleName;
    private String repository;
    private String parseBranchName;
    private RevisionFilter revisionFilter = new DefaultRevisionFilter();
    static /* synthetic */ Class class$net$sf$statcvs$input$Builder;

    public Builder(RepositoryFileManager repositoryFileManager, FilePatternMatcher includePattern, FilePatternMatcher excludePattern, String parseBranchName) {
        this.repositoryFileManager = repositoryFileManager;
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
        this.parseBranchName = parseBranchName;
        this.directories.put("", Directory.createRoot());
    }

    public void buildModule(String moduleName) {
        this.projectName = moduleName;
    }

    public void buildFile(String filename, Collection branches, boolean isBinary, boolean isInAttic) {
        if (this.currentFileBuilder != null) {
            this.fileBuilders.add(this.currentFileBuilder);
        }
        this.currentFileBuilder = new FileBuilder(this, filename, branches, isBinary, this.parseBranchName);
        if (isInAttic) {
            this.atticFileNames.add(filename);
        }
    }

    public void buildRevision(RevisionData data) {
        if (this.revisionFilter.isValid(data)) {
            try {
                this.currentFileBuilder.addRevisionData(data);
                if (this.startDate == null || this.startDate.compareTo(data.getDate()) > 0) {
                    this.startDate = data.getDate();
                }
            }
            catch (NoBranchException e) {
                logger.warn((Object)("Revision " + data.getRevisionNumber() + " has no main branch - ignoring revision."));
            }
        }
    }

    public CvsContent createCvsContent() throws EmptyRepositoryException {
        if (this.currentFileBuilder != null) {
            this.fileBuilders.add(this.currentFileBuilder);
            this.currentFileBuilder = null;
        }
        if (this.startDate == null) {
            throw new EmptyRepositoryException();
        }
        CvsContent result = new CvsContent();
        Iterator it = this.fileBuilders.iterator();
        while (it.hasNext()) {
            FileBuilder fileBuilder = (FileBuilder)it.next();
            CvsFile file = fileBuilder.createFile(this.startDate);
            if (file == null) continue;
            result.addFile(file);
            logger.debug((Object)("adding " + file.getFilenameWithPath() + " (" + file.getRevisions().size() + " revisions)"));
        }
        if (result.isEmpty()) {
            throw new EmptyRepositoryException();
        }
        SortedSet revisions = result.getRevisions();
        List commits = new CommitListBuilder(revisions).createCommitList();
        result.setCommits(commits);
        return result;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Set getAtticFileNames() {
        return this.atticFileNames;
    }

    public Author getAuthor(String name) {
        if (this.authors.containsKey(name)) {
            return (Author)this.authors.get(name);
        }
        Author newAuthor = new Author(name);
        this.authors.put(name, newAuthor);
        return newAuthor;
    }

    public Directory getDirectory(String filename) {
        int lastSlash = filename.lastIndexOf(47);
        if (lastSlash == -1) {
            return this.getDirectoryForPath("");
        }
        return this.getDirectoryForPath(filename.substring(0, lastSlash + 1));
    }

    public int getLOC(String filename) throws NoLineCountException {
        if (this.repositoryFileManager == null) {
            throw new NoLineCountException("no RepositoryFileManager");
        }
        return this.repositoryFileManager.getLinesOfCode(filename);
    }

    public boolean matchesPatterns(String filename) {
        if (this.excludePattern != null && this.excludePattern.matches(filename)) {
            return false;
        }
        if (this.includePattern != null) {
            return this.includePattern.matches(filename);
        }
        return true;
    }

    private Directory getDirectoryForPath(String path) {
        if (this.directories.containsKey(path)) {
            return (Directory)this.directories.get(path);
        }
        Directory parent = this.getDirectoryForPath(FileUtils.getParentDirectoryPath(path));
        Directory newDirectory = parent.createSubdirectory(FileUtils.getDirectoryName(path));
        this.directories.put(path, newDirectory);
        return newDirectory;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRevisionFilter(RevisionFilter revisionFilter) {
        this.revisionFilter = revisionFilter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

