/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.util.CvsLogUtils;

public class BranchData {
    public static final String HEAD_BRANCH_DATA_NAME = "HEAD";
    private String name;
    private String branchRevision;
    private String branchNumber;
    private String startRevisionNumber;

    public BranchData(String name, String branchRevision) throws LogSyntaxException {
        this.name = name;
        this.branchRevision = branchRevision;
        this.calculateRevisionNumbers(branchRevision);
    }

    public BranchData() {
        this.name = HEAD_BRANCH_DATA_NAME;
        this.branchRevision = "1.0.1";
    }

    protected void calculateRevisionNumbers(String branchRevision) throws LogSyntaxException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(branchRevision, ".");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (list.size() < 4) {
            throw new LogSyntaxException("Invalid branch revision:" + branchRevision);
        }
        StringBuffer result = new StringBuffer((String)list.get(0));
        for (int i = 1; i < list.size() - 2; ++i) {
            result.append(".").append(list.get(i));
        }
        this.startRevisionNumber = result.toString();
        this.branchNumber = result.append(".").append(list.get(list.size() - 1)).toString();
    }

    public boolean isOnBranch(String revisionNumber) throws LogSyntaxException {
        return this.branchNumber.equals(CvsLogUtils.calculateBranchNumber(revisionNumber));
    }

    public boolean isStartRevision(String revisionNumber) {
        return this.startRevisionNumber.equals(revisionNumber);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name='" + this.name + "' branchRevision='" + this.branchRevision + "' revisonNumber='" + this.branchNumber + " startRevisionNumber='" + this.startRevisionNumber + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BranchData)) {
            return false;
        }
        BranchData branch = (BranchData)o;
        if (!this.branchRevision.equals(branch.branchRevision)) {
            return false;
        }
        return this.name.equals(branch.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + this.branchRevision.hashCode();
        return result;
    }
}

