/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs;

import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import net.sf.statcvs.Messages;
import net.sf.statcvs.input.Builder;
import net.sf.statcvs.input.CvsLogfileParser;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.output.CommandLineParser;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLOutput;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    private static Logger logger = Logger.getLogger((String)"net.sf.statcvs");
    private static LogManager lm = new LogManager();
    static /* synthetic */ Class class$net$sf$statcvs$Main;

    public static void main(String[] args) {
        System.out.println(Messages.getString("PROJECT_NAME") + "\n");
        System.setProperty("java.awt.headless", "true");
        if (args.length == 0) {
            Main.printProperUsageAndExit();
        }
        if (args.length == 1) {
            String arg = args[0].toLowerCase();
            if (arg.equals("-h") || arg.equals("-help")) {
                Main.printProperUsageAndExit();
            } else if (arg.equals("-version")) {
                Main.printVersionAndExit();
            }
        }
        try {
            new CommandLineParser(args).parse();
            Main.generateDefaultHTMLSuite();
        }
        catch (ConfigurationException cex) {
            System.err.println(cex.getMessage());
            Main.printProperUsageAndExit();
        }
        catch (LogSyntaxException lex) {
            Main.printLogErrorMessageAndExit(lex.getMessage());
        }
        catch (IOException ioex) {
            Main.printIoErrorMessageAndExit(ioex.getMessage());
        }
        catch (OutOfMemoryError oome) {
            Main.printOutOfMemMessageAndExit();
        }
        catch (EmptyRepositoryException erex) {
            Main.printEmptyRepositoryMessageAndExit();
        }
        System.exit(0);
    }

    private static void initLogManager(String loggingProperties) {
        PropertyConfigurator.configure((URL)(class$net$sf$statcvs$Main == null ? (class$net$sf$statcvs$Main = Main.class$("net.sf.statcvs.Main")) : class$net$sf$statcvs$Main).getResource(loggingProperties));
    }

    private static void printProperUsageAndExit() {
        System.out.println("Usage: java -jar statcvs.jar [options] <logfile> <directory>\n\nRequired parameters:\n  <logfile>          path to the cvs logfile of the module\n  <directory>        path to the directory of the checked out module\n\nSome options:\n  -version           print the version information and exit\n  -output-dir <dir>  directory where HTML suite will be saved\n  -include <pattern> include only files matching pattern, e.g. **/*.c;**/*.h\n  -exclude <pattern> exclude matching files, e.g. tests/**;docs/**\n  -title <title>     Project title to be used in reports\n  -viewcvs <url>     integrate with ViewCVS installation at <url>\n  -verbose           print extra progress information\n\nFull options list: http://statcvs.sf.net/manual");
        System.exit(1);
    }

    private static void printVersionAndExit() {
        System.out.println("Version " + Messages.getString("CVS_VERSION_TAG"));
        System.exit(1);
    }

    private static void printOutOfMemMessageAndExit() {
        System.err.println("OutOfMemoryError.");
        System.err.println("Try running java with the -mx option (e.g. -mx128m for 128Mb).");
        System.exit(1);
    }

    private static void printLogErrorMessageAndExit(String message) {
        System.err.println("Logfile parsing failed.");
        System.err.println(message);
        System.exit(1);
    }

    private static void printIoErrorMessageAndExit(String message) {
        System.err.println(message);
        System.exit(1);
    }

    private static void printEmptyRepositoryMessageAndExit() {
        System.err.println("No revisions found in the log!");
        System.exit(1);
    }

    public static void generateDefaultHTMLSuite() throws LogSyntaxException, IOException, ConfigurationException, EmptyRepositoryException {
        if (ConfigurationOptions.getLogFileName() == null) {
            throw new ConfigurationException("Missing logfile name");
        }
        if (ConfigurationOptions.getCheckedOutDirectory() == null) {
            throw new ConfigurationException("Missing checked out directory");
        }
        long memoryUsedOnStart = Runtime.getRuntime().totalMemory();
        long startTime = System.currentTimeMillis();
        Main.initLogManager(ConfigurationOptions.getLoggingProperties());
        logger.info((Object)("Parsing CVS log '" + ConfigurationOptions.getLogFileName() + "'"));
        FileReader logReader = new FileReader(ConfigurationOptions.getLogFileName());
        RepositoryFileManager repFileMan = new RepositoryFileManager(ConfigurationOptions.getCheckedOutDirectory());
        Builder builder = new Builder(repFileMan, ConfigurationOptions.getIncludePattern(), ConfigurationOptions.getExcludePattern(), "HEAD");
        new CvsLogfileParser(logReader, builder).parse();
        if (ConfigurationOptions.getProjectName() == null) {
            ConfigurationOptions.setProjectName(builder.getProjectName());
        }
        if (ConfigurationOptions.getWebRepository() != null) {
            ConfigurationOptions.getWebRepository().setAtticFileNames(builder.getAtticFileNames());
        }
        logger.info((Object)("Generating report for " + ConfigurationOptions.getProjectName() + " into " + ConfigurationOptions.getOutputDir()));
        logger.info((Object)("Using " + ConfigurationOptions.getCssHandler()));
        CvsContent content = builder.createCvsContent();
        new HTMLOutput(content).createHTMLSuite();
        long endTime = System.currentTimeMillis();
        long memoryUsedOnEnd = Runtime.getRuntime().totalMemory();
        logger.info((Object)("runtime: " + ((double)endTime - (double)startTime) / 1000.0 + " seconds"));
        logger.info((Object)("memory usage: " + ((double)memoryUsedOnEnd - (double)memoryUsedOnStart) / 1024.0 + " kb"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

