/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.user;

import com.atlassian.core.user.BestNameComparator;
import com.atlassian.core.user.GroupUtils;
import com.atlassian.core.util.RandomGenerator;
import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserUtils {
    private static final Logger log = Logger.getLogger(UserUtils.class);

    public static User getUser(String username) throws EntityNotFoundException {
        return username == null ? null : UserManager.getInstance().getUser(username);
    }

    public static boolean existsUser(String username) {
        try {
            UserUtils.getUser(username);
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    public static Collection getAllUsers() {
        return UserManager.getInstance().getUsers();
    }

    public static User getUserByEmail(String email) throws EntityNotFoundException {
        String emailAddress = StringUtils.trimToNull((String)email);
        if (emailAddress != null) {
            for (User user : UserUtils.getAllUsers()) {
                if (!emailAddress.equalsIgnoreCase(user.getEmail())) continue;
                return user;
            }
        }
        throw new EntityNotFoundException("Could not find user with email: " + email);
    }

    public static List getUsersByEmail(String email) {
        ArrayList<User> users = new ArrayList<User>();
        String emailAddress = StringUtils.trimToNull((String)email);
        if (emailAddress != null) {
            for (User user : UserUtils.getAllUsers()) {
                if (!emailAddress.equalsIgnoreCase(user.getEmail())) continue;
                users.add(user);
            }
        }
        return users;
    }

    public static Collection getUsers(Collection groups) {
        if (groups == null || groups.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet usernames = new HashSet();
        for (Object o : groups) {
            if (o == null) {
                return UserUtils.getAllUsers();
            }
            Group group = o instanceof Group ? (Group)o : GroupUtils.getGroup((String)o);
            if (group == null) continue;
            usernames.addAll(group.getUsers());
        }
        ArrayList<User> users = new ArrayList<User>();
        for (String username : usernames) {
            try {
                users.add(UserUtils.getUser(username));
            }
            catch (EntityNotFoundException e) {
                log.error((Object)("Could not find user " + username + " but user was returned as in groups " + groups));
            }
        }
        Collections.sort(users, new BestNameComparator());
        return users;
    }

    public static User createUser(String username, String email) throws DuplicateEntityException, ImmutableException {
        return UserUtils.createUser(username, RandomGenerator.randomPassword(), email, null);
    }

    public static User createUser(String username, String email, String fullname) throws DuplicateEntityException, ImmutableException {
        return UserUtils.createUser(username, RandomGenerator.randomPassword(), email, fullname);
    }

    public static User createUser(String username, String password, String email, String fullname) throws DuplicateEntityException, ImmutableException {
        return UserUtils.createUser(username, password, email, fullname, null);
    }

    public static User createUser(String username, String password, String email, String fullname, Collection groups) throws DuplicateEntityException, ImmutableException {
        log.debug((Object)"UserUtils.createUser");
        try {
            UserManager.getInstance().getUser(username.toLowerCase());
            throw new DuplicateEntityException("The user " + username + " already exists.");
        }
        catch (EntityNotFoundException ex) {
            User user = UserManager.getInstance().createUser(username.toLowerCase());
            user.setEmail(email);
            user.setPassword(password);
            if (fullname == null) {
                fullname = username;
            }
            user.setFullName(fullname);
            if (groups != null) {
                for (String groupname : groups) {
                    user.addToGroup(GroupUtils.getGroup(groupname));
                }
            }
            return user;
        }
    }

    public static void removeUser(User user) throws Exception {
        user.remove();
    }

    public static String resetPassword(User user) throws ImmutableException {
        String newPassword = RandomGenerator.randomPassword();
        user.setPassword(newPassword);
        return newPassword;
    }

    public static void changePassword(User user, String password) throws ImmutableException {
        user.setPassword(password);
    }
}

