/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultMultiQueueTaskManager
implements MultiQueueTaskManager {
    private Map queues = new HashMap();

    public DefaultMultiQueueTaskManager(String queueName, TaskQueue queue) {
        this.addTaskQueue(queueName, queue);
    }

    public DefaultMultiQueueTaskManager(Map queues) {
        this.setTaskQueues(queues);
    }

    public void addTaskQueue(String name, TaskQueue queue) {
        if (this.queues.keySet().contains(name)) {
            throw new IllegalArgumentException("The queue specified already exists in the task manager");
        }
        this.queues.put(name, queue);
    }

    public TaskQueue removeTaskQueue(String queueName, TaskQueue taskQueue, boolean flush) {
        TaskQueue queue = this.getTaskQueue(queueName);
        if (queue != null && flush) {
            queue.flush();
        }
        return queue;
    }

    public TaskQueue getTaskQueue(String name) {
        return (TaskQueue)this.queues.get(name);
    }

    public void setTaskQueues(Map queues) {
        for (Map.Entry entry : queues.entrySet()) {
            this.addTaskQueue(entry.getKey().toString(), (TaskQueue)entry.getValue());
        }
    }

    public void addTask(String queueName, Task task) {
        this.getTaskQueue(queueName).addTask(task);
    }

    public void flush(String queueName) {
        this.getTaskQueue(queueName).flush();
    }

    public void flush() {
        Iterator iterator = this.queues.values().iterator();
        while (iterator.hasNext()) {
            ((TaskQueue)iterator.next()).flush();
        }
    }
}

