/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.ofbiz;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.Entity;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ejb.util.Base64;
import com.opensymphony.user.provider.ejb.util.PasswordDigester;
import com.opensymphony.user.provider.ofbiz.OFBizAbstractProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.util.UtilMisc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFBizCredentialsProvider
extends OFBizAbstractProvider
implements CredentialsProvider {
    private static final Logger LOG = Logger.getLogger(OFBizCredentialsProvider.class);
    protected String userSequence;

    @Override
    public boolean authenticate(String name, String password) {
        try {
            GenericValue v = this.findUser(name);
            if (v == null) {
                return false;
            }
            String passwordHash = v.getString("passwordHash");
            if (password == null || passwordHash == null || password.length() == 0) {
                return false;
            }
            return this.compareHash(passwordHash, password);
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not authenticate user", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean changePassword(String name, String password) {
        try {
            GenericValue v = this.findUser(name);
            if (v == null) {
                return false;
            }
            this.clearUserCache(name);
            this.clearAllCache();
            v.set("passwordHash", (Object)this.createHash(password));
            v.store();
            return true;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not change password", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean create(String name) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating user: " + name));
            }
            Long id = this.getDelegator().getNextSeqId(this.userSequence);
            GenericValue v = this.getDelegator().makeValue(this.userEntity, UtilMisc.toMap((String)"name", (Object)name, (String)"id", (Object)id));
            this.clearAllCache();
            v.create();
        }
        catch (GenericEntityException e) {
            LOG.error((Object)("GenericEntityException creating user : " + name + " : " + (Object)((Object)e)), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean handles(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OFBizCredentialsProvider.handles(" + name + ")"));
        }
        try {
            if (this.findUser(name) != null) {
                return true;
            }
        }
        catch (GenericEntityException e) {
            LOG.warn((Object)"did not handle user", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean init(Properties properties) {
        boolean superResult = super.init(properties);
        this.userSequence = properties.getProperty("userSequence", "OSUser");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("userSequence: " + this.userSequence));
        }
        return superResult;
    }

    @Override
    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<String> order = Collections.singletonList("name asc");
            List col = this.getDelegator().findAll(this.userEntity, order);
            for (GenericValue o : col) {
                list.add(o.getString("name"));
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not list users", (Throwable)e);
        }
        return list;
    }

    @Override
    public boolean load(String name, Entity.Accessor accessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("name = " + name));
        }
        try {
            GenericValue user = this.findUser(name);
            accessor.setName(user.getString("name"));
            accessor.setMutable(true);
            return true;
        }
        catch (GenericEntityException e) {
            return false;
        }
    }

    @Override
    public boolean remove(String name) {
        try {
            List<String> userGroups;
            TransactionUtil.begin();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to remove properties for: " + name));
            }
            User user = UserManager.getInstance().getUser(name);
            PropertySet props = user.getPropertySet();
            Iterator keyIter = props.getKeys().iterator();
            while (keyIter.hasNext()) {
                props.remove((String)keyIter.next());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to remove groups for: " + name));
            }
            if ((userGroups = user.getGroups()) != null) {
                for (String element : userGroups) {
                    user.getAccessProvider().removeFromGroup(name, element);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("trying to remove user: " + name));
            }
            this.clearUserCache(name);
            this.clearAllCache();
            this.getDelegator().removeByAnd(this.userEntity, UtilMisc.toMap((String)"name", (Object)name));
            if (TransactionUtil.getStatus() != 6) {
                TransactionUtil.commit();
            }
            return true;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)("Could not remove user: " + name), (Throwable)e);
            try {
                TransactionUtil.rollback();
            }
            catch (GenericTransactionException e1) {
                LOG.error((Object)("Could not remove user: " + name), (Throwable)e1);
                return false;
            }
            return false;
        }
        catch (EntityNotFoundException e) {
            LOG.error((Object)("Could not remove user: " + name), (Throwable)e);
            try {
                TransactionUtil.rollback();
            }
            catch (GenericTransactionException e1) {
                LOG.error((Object)("Could not remove user: " + name), (Throwable)e1);
                return false;
            }
            return false;
        }
    }

    private boolean compareHash(String hashedValue, String unhashedValue) {
        return hashedValue.equals(this.createHash(unhashedValue));
    }

    private String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }
}

